/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.applications._CreateApplicationRequest;

public final class CreateApplicationRequest
extends _CreateApplicationRequest {
    @Nullable
    private final String buildpack;
    @Nullable
    private final String command;
    @Nullable
    private final Boolean console;
    @Nullable
    private final String debug;
    @Nullable
    private final String detectedStartCommand;
    @Nullable
    private final Boolean diego;
    @Nullable
    private final Integer diskQuota;
    @Nullable
    private final Map<String, Object> dockerCredentialsJsons;
    @Nullable
    private final String dockerImage;
    @Nullable
    private final Boolean enableSsh;
    @Nullable
    private final Map<String, Object> environmentJsons;
    @Nullable
    private final Integer healthCheckTimeout;
    @Nullable
    private final String healthCheckType;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Integer memory;
    private final String name;
    @Nullable
    private final List<Integer> ports;
    @Nullable
    private final Boolean production;
    private final String spaceId;
    @Nullable
    private final String stackId;
    @Nullable
    private final String state;

    private CreateApplicationRequest(Builder builder) {
        this.buildpack = builder.buildpack;
        this.command = builder.command;
        this.console = builder.console;
        this.debug = builder.debug;
        this.detectedStartCommand = builder.detectedStartCommand;
        this.diego = builder.diego;
        this.diskQuota = builder.diskQuota;
        this.dockerCredentialsJsons = builder.dockerCredentialsJsons == null ? null : CreateApplicationRequest.createUnmodifiableMap(false, false, builder.dockerCredentialsJsons);
        this.dockerImage = builder.dockerImage;
        this.enableSsh = builder.enableSsh;
        this.environmentJsons = builder.environmentJsons == null ? null : CreateApplicationRequest.createUnmodifiableMap(false, false, builder.environmentJsons);
        this.healthCheckTimeout = builder.healthCheckTimeout;
        this.healthCheckType = builder.healthCheckType;
        this.instances = builder.instances;
        this.memory = builder.memory;
        this.name = builder.name;
        this.ports = builder.ports == null ? null : CreateApplicationRequest.createUnmodifiableList(true, builder.ports);
        this.production = builder.production;
        this.spaceId = builder.spaceId;
        this.stackId = builder.stackId;
        this.state = builder.state;
    }

    @Override
    @Nullable
    public String getBuildpack() {
        return this.buildpack;
    }

    @Override
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @Deprecated
    @Nullable
    public Boolean getConsole() {
        return this.console;
    }

    @Override
    @Deprecated
    @Nullable
    public String getDebug() {
        return this.debug;
    }

    @Override
    @Nullable
    public String getDetectedStartCommand() {
        return this.detectedStartCommand;
    }

    @Override
    @Nullable
    public Boolean getDiego() {
        return this.diego;
    }

    @Override
    @Nullable
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    @Nullable
    public Map<String, Object> getDockerCredentialsJsons() {
        return this.dockerCredentialsJsons;
    }

    @Override
    @Nullable
    public String getDockerImage() {
        return this.dockerImage;
    }

    @Override
    @Nullable
    public Boolean getEnableSsh() {
        return this.enableSsh;
    }

    @Override
    @Nullable
    public Map<String, Object> getEnvironmentJsons() {
        return this.environmentJsons;
    }

    @Override
    @Nullable
    public Integer getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    @Override
    @Nullable
    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    @Override
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @Nullable
    public Integer getMemory() {
        return this.memory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    @Deprecated
    @Nullable
    public Boolean getProduction() {
        return this.production;
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @Nullable
    public String getStackId() {
        return this.stackId;
    }

    @Override
    @Nullable
    public String getState() {
        return this.state;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateApplicationRequest && this.equalTo((CreateApplicationRequest)another);
    }

    private boolean equalTo(CreateApplicationRequest another) {
        return Objects.equals(this.buildpack, another.buildpack) && Objects.equals(this.command, another.command) && Objects.equals(this.console, another.console) && Objects.equals(this.debug, another.debug) && Objects.equals(this.detectedStartCommand, another.detectedStartCommand) && Objects.equals(this.diego, another.diego) && Objects.equals(this.diskQuota, another.diskQuota) && Objects.equals(this.dockerCredentialsJsons, another.dockerCredentialsJsons) && Objects.equals(this.dockerImage, another.dockerImage) && Objects.equals(this.enableSsh, another.enableSsh) && Objects.equals(this.environmentJsons, another.environmentJsons) && Objects.equals(this.healthCheckTimeout, another.healthCheckTimeout) && Objects.equals(this.healthCheckType, another.healthCheckType) && Objects.equals(this.instances, another.instances) && Objects.equals(this.memory, another.memory) && this.name.equals(another.name) && Objects.equals(this.ports, another.ports) && Objects.equals(this.production, another.production) && this.spaceId.equals(another.spaceId) && Objects.equals(this.stackId, another.stackId) && Objects.equals(this.state, another.state);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.buildpack);
        h = h * 17 + Objects.hashCode(this.command);
        h = h * 17 + Objects.hashCode(this.console);
        h = h * 17 + Objects.hashCode(this.debug);
        h = h * 17 + Objects.hashCode(this.detectedStartCommand);
        h = h * 17 + Objects.hashCode(this.diego);
        h = h * 17 + Objects.hashCode(this.diskQuota);
        h = h * 17 + Objects.hashCode(this.dockerCredentialsJsons);
        h = h * 17 + Objects.hashCode(this.dockerImage);
        h = h * 17 + Objects.hashCode(this.enableSsh);
        h = h * 17 + Objects.hashCode(this.environmentJsons);
        h = h * 17 + Objects.hashCode(this.healthCheckTimeout);
        h = h * 17 + Objects.hashCode(this.healthCheckType);
        h = h * 17 + Objects.hashCode(this.instances);
        h = h * 17 + Objects.hashCode(this.memory);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.ports);
        h = h * 17 + Objects.hashCode(this.production);
        h = h * 17 + this.spaceId.hashCode();
        h = h * 17 + Objects.hashCode(this.stackId);
        h = h * 17 + Objects.hashCode(this.state);
        return h;
    }

    public String toString() {
        return "CreateApplicationRequest{buildpack=" + this.buildpack + ", command=" + this.command + ", console=" + this.console + ", debug=" + this.debug + ", detectedStartCommand=" + this.detectedStartCommand + ", diego=" + this.diego + ", diskQuota=" + this.diskQuota + ", dockerCredentialsJsons=" + this.dockerCredentialsJsons + ", dockerImage=" + this.dockerImage + ", enableSsh=" + this.enableSsh + ", environmentJsons=" + this.environmentJsons + ", healthCheckTimeout=" + this.healthCheckTimeout + ", healthCheckType=" + this.healthCheckType + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", ports=" + this.ports + ", production=" + this.production + ", spaceId=" + this.spaceId + ", stackId=" + this.stackId + ", state=" + this.state + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SPACE_ID = 2L;
        private long initBits = 3L;
        private String buildpack;
        private String command;
        private Boolean console;
        private String debug;
        private String detectedStartCommand;
        private Boolean diego;
        private Integer diskQuota;
        private Map<String, Object> dockerCredentialsJsons = null;
        private String dockerImage;
        private Boolean enableSsh;
        private Map<String, Object> environmentJsons = null;
        private Integer healthCheckTimeout;
        private String healthCheckType;
        private Integer instances;
        private Integer memory;
        private String name;
        private List<Integer> ports = null;
        private Boolean production;
        private String spaceId;
        private String stackId;
        private String state;

        private Builder() {
        }

        public final Builder from(CreateApplicationRequest instance) {
            return this.from((_CreateApplicationRequest)instance);
        }

        final Builder from(_CreateApplicationRequest instance) {
            String stateValue;
            Boolean productionValue;
            Integer memoryValue;
            Integer instancesValue;
            String healthCheckTypeValue;
            Integer healthCheckTimeoutValue;
            Map<String, Object> environmentJsonsValue;
            Boolean enableSshValue;
            String dockerImageValue;
            Map<String, Object> dockerCredentialsJsonsValue;
            Integer diskQuotaValue;
            Boolean diegoValue;
            String detectedStartCommandValue;
            String debugValue;
            Boolean consoleValue;
            String commandValue;
            Objects.requireNonNull(instance, "instance");
            String buildpackValue = instance.getBuildpack();
            if (buildpackValue != null) {
                this.buildpack(buildpackValue);
            }
            if ((commandValue = instance.getCommand()) != null) {
                this.command(commandValue);
            }
            if ((consoleValue = instance.getConsole()) != null) {
                this.console(consoleValue);
            }
            if ((debugValue = instance.getDebug()) != null) {
                this.debug(debugValue);
            }
            if ((detectedStartCommandValue = instance.getDetectedStartCommand()) != null) {
                this.detectedStartCommand(detectedStartCommandValue);
            }
            if ((diegoValue = instance.getDiego()) != null) {
                this.diego(diegoValue);
            }
            if ((diskQuotaValue = instance.getDiskQuota()) != null) {
                this.diskQuota(diskQuotaValue);
            }
            if ((dockerCredentialsJsonsValue = instance.getDockerCredentialsJsons()) != null) {
                this.putAllDockerCredentialsJsons(dockerCredentialsJsonsValue);
            }
            if ((dockerImageValue = instance.getDockerImage()) != null) {
                this.dockerImage(dockerImageValue);
            }
            if ((enableSshValue = instance.getEnableSsh()) != null) {
                this.enableSsh(enableSshValue);
            }
            if ((environmentJsonsValue = instance.getEnvironmentJsons()) != null) {
                this.putAllEnvironmentJsons(environmentJsonsValue);
            }
            if ((healthCheckTimeoutValue = instance.getHealthCheckTimeout()) != null) {
                this.healthCheckTimeout(healthCheckTimeoutValue);
            }
            if ((healthCheckTypeValue = instance.getHealthCheckType()) != null) {
                this.healthCheckType(healthCheckTypeValue);
            }
            if ((instancesValue = instance.getInstances()) != null) {
                this.instances(instancesValue);
            }
            if ((memoryValue = instance.getMemory()) != null) {
                this.memory(memoryValue);
            }
            this.name(instance.getName());
            List<Integer> portsValue = instance.getPorts();
            if (portsValue != null) {
                this.addAllPorts(portsValue);
            }
            if ((productionValue = instance.getProduction()) != null) {
                this.production(productionValue);
            }
            this.spaceId(instance.getSpaceId());
            String stackIdValue = instance.getStackId();
            if (stackIdValue != null) {
                this.stackId(stackIdValue);
            }
            if ((stateValue = instance.getState()) != null) {
                this.state(stateValue);
            }
            return this;
        }

        public final Builder buildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        @Deprecated
        public final Builder console(@Nullable Boolean console) {
            this.console = console;
            return this;
        }

        @Deprecated
        public final Builder debug(@Nullable String debug) {
            this.debug = debug;
            return this;
        }

        public final Builder detectedStartCommand(@Nullable String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
            return this;
        }

        public final Builder diego(@Nullable Boolean diego) {
            this.diego = diego;
            return this;
        }

        public final Builder diskQuota(@Nullable Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        public final Builder dockerCredentialsJson(String key, Object value) {
            if (this.dockerCredentialsJsons == null) {
                this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
            }
            this.dockerCredentialsJsons.put(Objects.requireNonNull(key, "dockerCredentialsJsons key"), Objects.requireNonNull(value, "dockerCredentialsJsons value"));
            return this;
        }

        public final Builder dockerCredentialsJson(Map.Entry<String, ? extends Object> entry) {
            if (this.dockerCredentialsJsons == null) {
                this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.dockerCredentialsJsons.put(Objects.requireNonNull(k, "dockerCredentialsJsons key"), Objects.requireNonNull(v, "dockerCredentialsJsons value"));
            return this;
        }

        public final Builder dockerCredentialsJsons(@Nullable Map<String, ? extends Object> dockerCredentialsJsons) {
            if (dockerCredentialsJsons == null) {
                this.dockerCredentialsJsons = null;
                return this;
            }
            this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
            return this.putAllDockerCredentialsJsons(dockerCredentialsJsons);
        }

        public final Builder putAllDockerCredentialsJsons(Map<String, ? extends Object> dockerCredentialsJsons) {
            if (this.dockerCredentialsJsons == null) {
                this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : dockerCredentialsJsons.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.dockerCredentialsJsons.put(Objects.requireNonNull(k, "dockerCredentialsJsons key"), Objects.requireNonNull(v, "dockerCredentialsJsons value"));
            }
            return this;
        }

        public final Builder dockerImage(@Nullable String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        public final Builder enableSsh(@Nullable Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        public final Builder environmentJson(String key, Object value) {
            if (this.environmentJsons == null) {
                this.environmentJsons = new LinkedHashMap<String, Object>();
            }
            this.environmentJsons.put(Objects.requireNonNull(key, "environmentJsons key"), Objects.requireNonNull(value, "environmentJsons value"));
            return this;
        }

        public final Builder environmentJson(Map.Entry<String, ? extends Object> entry) {
            if (this.environmentJsons == null) {
                this.environmentJsons = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentJsons.put(Objects.requireNonNull(k, "environmentJsons key"), Objects.requireNonNull(v, "environmentJsons value"));
            return this;
        }

        public final Builder environmentJsons(@Nullable Map<String, ? extends Object> environmentJsons) {
            if (environmentJsons == null) {
                this.environmentJsons = null;
                return this;
            }
            this.environmentJsons = new LinkedHashMap<String, Object>();
            return this.putAllEnvironmentJsons(environmentJsons);
        }

        public final Builder putAllEnvironmentJsons(Map<String, ? extends Object> environmentJsons) {
            if (this.environmentJsons == null) {
                this.environmentJsons = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : environmentJsons.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.environmentJsons.put(Objects.requireNonNull(k, "environmentJsons key"), Objects.requireNonNull(v, "environmentJsons value"));
            }
            return this;
        }

        public final Builder healthCheckTimeout(@Nullable Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        public final Builder healthCheckType(@Nullable String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Builder memory(@Nullable Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder port(int element) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            this.ports.add(element);
            return this;
        }

        public final Builder port(int ... elements) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(element);
            }
            return this;
        }

        public final Builder ports(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.ports = null;
                return this;
            }
            this.ports = new ArrayList<Integer>();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "ports element");
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(Objects.requireNonNull(Integer.valueOf(element), "ports element"));
            }
            return this;
        }

        @Deprecated
        public final Builder production(@Nullable Boolean production) {
            this.production = production;
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder stackId(@Nullable String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        public CreateApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("spaceId");
            }
            return "Cannot build CreateApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

