/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.applications._ListApplicationRoutesRequest;

public final class ListApplicationRoutesRequest
extends _ListApplicationRoutesRequest {
    private final String applicationId;
    @Nullable
    private final List<String> domainIds;
    @Nullable
    private final List<String> hosts;
    @Nullable
    private final List<String> paths;
    @Nullable
    private final List<Integer> ports;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListApplicationRoutesRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.domainIds = builder.domainIds == null ? null : ListApplicationRoutesRequest.createUnmodifiableList(true, builder.domainIds);
        this.hosts = builder.hosts == null ? null : ListApplicationRoutesRequest.createUnmodifiableList(true, builder.hosts);
        this.paths = builder.paths == null ? null : ListApplicationRoutesRequest.createUnmodifiableList(true, builder.paths);
        this.ports = builder.ports == null ? null : ListApplicationRoutesRequest.createUnmodifiableList(true, builder.ports);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nullable
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    @Override
    @Nullable
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    @Nullable
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    @Nullable
    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListApplicationRoutesRequest && this.equalTo((ListApplicationRoutesRequest)another);
    }

    private boolean equalTo(ListApplicationRoutesRequest another) {
        return this.applicationId.equals(another.applicationId) && Objects.equals(this.domainIds, another.domainIds) && Objects.equals(this.hosts, another.hosts) && Objects.equals(this.paths, another.paths) && Objects.equals(this.ports, another.ports) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + Objects.hashCode(this.domainIds);
        h = h * 17 + Objects.hashCode(this.hosts);
        h = h * 17 + Objects.hashCode(this.paths);
        h = h * 17 + Objects.hashCode(this.ports);
        h = h * 17 + Objects.hashCode((Object)this.orderDirection);
        h = h * 17 + Objects.hashCode(this.page);
        h = h * 17 + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListApplicationRoutesRequest{applicationId=" + this.applicationId + ", domainIds=" + this.domainIds + ", hosts=" + this.hosts + ", paths=" + this.paths + ", ports=" + this.ports + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String applicationId;
        private List<String> domainIds = null;
        private List<String> hosts = null;
        private List<String> paths = null;
        private List<Integer> ports = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListApplicationRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListApplicationRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListApplicationRoutesRequest) {
                List<String> pathsValue;
                List<String> hostsValue;
                instance = (_ListApplicationRoutesRequest)object;
                List<String> domainIdsValue = ((_ListApplicationRoutesRequest)instance).getDomainIds();
                if (domainIdsValue != null) {
                    this.addAllDomainIds(domainIdsValue);
                }
                this.applicationId(((_ListApplicationRoutesRequest)instance).getApplicationId());
                List<Integer> portsValue = ((_ListApplicationRoutesRequest)instance).getPorts();
                if (portsValue != null) {
                    this.addAllPorts(portsValue);
                }
                if ((hostsValue = ((_ListApplicationRoutesRequest)instance).getHosts()) != null) {
                    this.addAllHosts(hostsValue);
                }
                if ((pathsValue = ((_ListApplicationRoutesRequest)instance).getPaths()) != null) {
                    this.addAllPaths(pathsValue);
                }
            }
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder domainId(String element) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            return this;
        }

        public final Builder domainId(String ... elements) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder domainIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.domainIds = null;
                return this;
            }
            this.domainIds = new ArrayList<String>();
            return this.addAllDomainIds(elements);
        }

        public final Builder addAllDomainIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "domainIds element");
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder host(String element) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            return this;
        }

        public final Builder host(String ... elements) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        public final Builder hosts(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.hosts = null;
                return this;
            }
            this.hosts = new ArrayList<String>();
            return this.addAllHosts(elements);
        }

        public final Builder addAllHosts(Iterable<String> elements) {
            Objects.requireNonNull(elements, "hosts element");
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        public final Builder path(String element) {
            if (this.paths == null) {
                this.paths = new ArrayList<String>();
            }
            this.paths.add(Objects.requireNonNull(element, "paths element"));
            return this;
        }

        public final Builder path(String ... elements) {
            if (this.paths == null) {
                this.paths = new ArrayList<String>();
            }
            for (String element : elements) {
                this.paths.add(Objects.requireNonNull(element, "paths element"));
            }
            return this;
        }

        public final Builder paths(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.paths = null;
                return this;
            }
            this.paths = new ArrayList<String>();
            return this.addAllPaths(elements);
        }

        public final Builder addAllPaths(Iterable<String> elements) {
            Objects.requireNonNull(elements, "paths element");
            if (this.paths == null) {
                this.paths = new ArrayList<String>();
            }
            for (String element : elements) {
                this.paths.add(Objects.requireNonNull(element, "paths element"));
            }
            return this;
        }

        public final Builder port(int element) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            this.ports.add(element);
            return this;
        }

        public final Builder port(int ... elements) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(element);
            }
            return this;
        }

        public final Builder ports(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.ports = null;
                return this;
            }
            this.ports = new ArrayList<Integer>();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "ports element");
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(Objects.requireNonNull(Integer.valueOf(element), "ports element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListApplicationRoutesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListApplicationRoutesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build ListApplicationRoutesRequest, some of required attributes are not set " + attributes;
        }
    }
}

