/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.buildpacks;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.buildpacks._CreateBuildpackRequest;

public final class CreateBuildpackRequest
extends _CreateBuildpackRequest {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final String filename;
    @Nullable
    private final Boolean locked;
    private final String name;
    @Nullable
    private final Integer position;

    private CreateBuildpackRequest(Builder builder) {
        this.enabled = builder.enabled;
        this.filename = builder.filename;
        this.locked = builder.locked;
        this.name = builder.name;
        this.position = builder.position;
    }

    @Override
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @Nullable
    public String getFilename() {
        return this.filename;
    }

    @Override
    @Nullable
    public Boolean getLocked() {
        return this.locked;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Integer getPosition() {
        return this.position;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateBuildpackRequest && this.equalTo((CreateBuildpackRequest)another);
    }

    private boolean equalTo(CreateBuildpackRequest another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.filename, another.filename) && Objects.equals(this.locked, another.locked) && this.name.equals(another.name) && Objects.equals(this.position, another.position);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.enabled);
        h = h * 17 + Objects.hashCode(this.filename);
        h = h * 17 + Objects.hashCode(this.locked);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.position);
        return h;
    }

    public String toString() {
        return "CreateBuildpackRequest{enabled=" + this.enabled + ", filename=" + this.filename + ", locked=" + this.locked + ", name=" + this.name + ", position=" + this.position + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Boolean enabled;
        private String filename;
        private Boolean locked;
        private String name;
        private Integer position;

        private Builder() {
        }

        public final Builder from(CreateBuildpackRequest instance) {
            return this.from((_CreateBuildpackRequest)instance);
        }

        final Builder from(_CreateBuildpackRequest instance) {
            Boolean lockedValue;
            String filenameValue;
            Objects.requireNonNull(instance, "instance");
            Boolean enabledValue = instance.getEnabled();
            if (enabledValue != null) {
                this.enabled(enabledValue);
            }
            if ((filenameValue = instance.getFilename()) != null) {
                this.filename(filenameValue);
            }
            if ((lockedValue = instance.getLocked()) != null) {
                this.locked(lockedValue);
            }
            this.name(instance.getName());
            Integer positionValue = instance.getPosition();
            if (positionValue != null) {
                this.position(positionValue);
            }
            return this;
        }

        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Builder filename(@Nullable String filename) {
            this.filename = filename;
            return this;
        }

        public final Builder locked(@Nullable Boolean locked) {
            this.locked = locked;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder position(@Nullable Integer position) {
            this.position = position;
            return this;
        }

        public CreateBuildpackRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateBuildpackRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateBuildpackRequest, some of required attributes are not set " + attributes;
        }
    }
}

