/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.buildpacks;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.buildpacks._UploadBuildpackRequest;

public final class UploadBuildpackRequest
extends _UploadBuildpackRequest {
    private final InputStream buildpack;
    private final String buildpackId;
    private final String filename;

    private UploadBuildpackRequest(Builder builder) {
        this.buildpack = builder.buildpack;
        this.buildpackId = builder.buildpackId;
        this.filename = builder.filename;
    }

    @Override
    public InputStream getBuildpack() {
        return this.buildpack;
    }

    @Override
    public String getBuildpackId() {
        return this.buildpackId;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UploadBuildpackRequest && this.equalTo((UploadBuildpackRequest)another);
    }

    private boolean equalTo(UploadBuildpackRequest another) {
        return this.buildpack.equals(another.buildpack) && this.buildpackId.equals(another.buildpackId) && this.filename.equals(another.filename);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.buildpack.hashCode();
        h = h * 17 + this.buildpackId.hashCode();
        h = h * 17 + this.filename.hashCode();
        return h;
    }

    public String toString() {
        return "UploadBuildpackRequest{buildpack=" + this.buildpack + ", buildpackId=" + this.buildpackId + ", filename=" + this.filename + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BUILDPACK = 1L;
        private static final long INIT_BIT_BUILDPACK_ID = 2L;
        private static final long INIT_BIT_FILENAME = 4L;
        private long initBits = 7L;
        private InputStream buildpack;
        private String buildpackId;
        private String filename;

        private Builder() {
        }

        public final Builder from(UploadBuildpackRequest instance) {
            return this.from((_UploadBuildpackRequest)instance);
        }

        final Builder from(_UploadBuildpackRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.buildpack(instance.getBuildpack());
            this.buildpackId(instance.getBuildpackId());
            this.filename(instance.getFilename());
            return this;
        }

        public final Builder buildpack(InputStream buildpack) {
            this.buildpack = Objects.requireNonNull(buildpack, "buildpack");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder buildpackId(String buildpackId) {
            this.buildpackId = Objects.requireNonNull(buildpackId, "buildpackId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder filename(String filename) {
            this.filename = Objects.requireNonNull(filename, "filename");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public UploadBuildpackRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UploadBuildpackRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("buildpack");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("buildpackId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("filename");
            }
            return "Cannot build UploadBuildpackRequest, some of required attributes are not set " + attributes;
        }
    }
}

