/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.domains._Domain;

public final class Domain
extends _Domain {
    @Nullable
    private final String id;
    @Nullable
    private final String name;
    @Nullable
    private final String owningOrganizationId;
    @Nullable
    private final String routerGroupId;
    @Nullable
    private final String routerGroupType;

    private Domain(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.owningOrganizationId = builder.owningOrganizationId;
        this.routerGroupId = builder.routerGroupId;
        this.routerGroupType = builder.routerGroupType;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="owning_organization_guid")
    @Nullable
    public String getOwningOrganizationId() {
        return this.owningOrganizationId;
    }

    @Override
    @JsonProperty(value="router_group_guid")
    @Nullable
    public String getRouterGroupId() {
        return this.routerGroupId;
    }

    @Override
    @JsonProperty(value="router_group_type")
    @Nullable
    public String getRouterGroupType() {
        return this.routerGroupType;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Domain && this.equalTo((Domain)another);
    }

    private boolean equalTo(Domain another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.name, another.name) && Objects.equals(this.owningOrganizationId, another.owningOrganizationId) && Objects.equals(this.routerGroupId, another.routerGroupId) && Objects.equals(this.routerGroupType, another.routerGroupType);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.id);
        h = h * 17 + Objects.hashCode(this.name);
        h = h * 17 + Objects.hashCode(this.owningOrganizationId);
        h = h * 17 + Objects.hashCode(this.routerGroupId);
        h = h * 17 + Objects.hashCode(this.routerGroupType);
        return h;
    }

    public String toString() {
        return "Domain{id=" + this.id + ", name=" + this.name + ", owningOrganizationId=" + this.owningOrganizationId + ", routerGroupId=" + this.routerGroupId + ", routerGroupType=" + this.routerGroupType + "}";
    }

    @Deprecated
    @JsonCreator
    static Domain fromJson(Json json) {
        Builder builder = Domain.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.owningOrganizationId != null) {
            builder.owningOrganizationId(json.owningOrganizationId);
        }
        if (json.routerGroupId != null) {
            builder.routerGroupId(json.routerGroupId);
        }
        if (json.routerGroupType != null) {
            builder.routerGroupType(json.routerGroupType);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String owningOrganizationId;
        private String routerGroupId;
        private String routerGroupType;

        private Builder() {
        }

        public final Builder from(Domain instance) {
            return this.from((_Domain)instance);
        }

        final Builder from(_Domain instance) {
            String routerGroupTypeValue;
            String routerGroupIdValue;
            String owningOrganizationIdValue;
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((owningOrganizationIdValue = instance.getOwningOrganizationId()) != null) {
                this.owningOrganizationId(owningOrganizationIdValue);
            }
            if ((routerGroupIdValue = instance.getRouterGroupId()) != null) {
                this.routerGroupId(routerGroupIdValue);
            }
            if ((routerGroupTypeValue = instance.getRouterGroupType()) != null) {
                this.routerGroupType(routerGroupTypeValue);
            }
            return this;
        }

        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder owningOrganizationId(@Nullable String owningOrganizationId) {
            this.owningOrganizationId = owningOrganizationId;
            return this;
        }

        public final Builder routerGroupId(@Nullable String routerGroupId) {
            this.routerGroupId = routerGroupId;
            return this;
        }

        public final Builder routerGroupType(@Nullable String routerGroupType) {
            this.routerGroupType = routerGroupType;
            return this;
        }

        public Domain build() {
            return new Domain(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Domain {
        String id;
        String name;
        String owningOrganizationId;
        String routerGroupId;
        String routerGroupType;

        Json() {
        }

        @JsonProperty(value="guid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="owning_organization_guid")
        public void setOwningOrganizationId(@Nullable String owningOrganizationId) {
            this.owningOrganizationId = owningOrganizationId;
        }

        @JsonProperty(value="router_group_guid")
        public void setRouterGroupId(@Nullable String routerGroupId) {
            this.routerGroupId = routerGroupId;
        }

        @JsonProperty(value="router_group_type")
        public void setRouterGroupType(@Nullable String routerGroupType) {
            this.routerGroupType = routerGroupType;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOwningOrganizationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouterGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouterGroupType() {
            throw new UnsupportedOperationException();
        }
    }
}

