/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.environmentvariablegroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v2.environmentvariablegroups._GetStagingEnvironmentVariablesResponse;

public final class GetStagingEnvironmentVariablesResponse
extends _GetStagingEnvironmentVariablesResponse {
    private final Map<String, Object> environmentVariables;

    private GetStagingEnvironmentVariablesResponse(Builder builder) {
        this.environmentVariables = GetStagingEnvironmentVariablesResponse.createUnmodifiableMap(false, false, builder.environmentVariables);
    }

    @Override
    @JsonProperty(value="environmentVariables")
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetStagingEnvironmentVariablesResponse && this.equalTo((GetStagingEnvironmentVariablesResponse)another);
    }

    private boolean equalTo(GetStagingEnvironmentVariablesResponse another) {
        return this.environmentVariables.equals(another.environmentVariables);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.environmentVariables.hashCode();
        return h;
    }

    public String toString() {
        return "GetStagingEnvironmentVariablesResponse{environmentVariables=" + this.environmentVariables + "}";
    }

    @Deprecated
    @JsonCreator
    static GetStagingEnvironmentVariablesResponse fromJson(Json json) {
        Builder builder = GetStagingEnvironmentVariablesResponse.builder();
        if (json.environmentVariables != null) {
            builder.putAllEnvironmentVariables(json.environmentVariables);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Map<String, Object> environmentVariables = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public final Builder from(GetStagingEnvironmentVariablesResponse instance) {
            return this.from((_GetStagingEnvironmentVariablesResponse)instance);
        }

        final Builder from(_GetStagingEnvironmentVariablesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllEnvironmentVariables(instance.getEnvironmentVariables());
            return this;
        }

        public final Builder environmentVariable(String key, Object value) {
            this.environmentVariables.put(Objects.requireNonNull(key, "environmentVariables key"), Objects.requireNonNull(value, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariables(Map<String, ? extends Object> environmentVariables) {
            this.environmentVariables.clear();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
            for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            }
            return this;
        }

        public GetStagingEnvironmentVariablesResponse build() {
            return new GetStagingEnvironmentVariablesResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _GetStagingEnvironmentVariablesResponse {
        Map<String, Object> environmentVariables;

        Json() {
        }

        @JsonProperty(value="environmentVariables")
        public void setEnvironmentVariables(Map<String, Object> environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        @Override
        public Map<String, Object> getEnvironmentVariables() {
            throw new UnsupportedOperationException();
        }
    }
}

