/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.jobs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.jobs.ErrorDetails;
import org.cloudfoundry.client.v2.jobs._JobEntity;

public final class JobEntity
extends _JobEntity {
    @Nullable
    private final String error;
    @Nullable
    private final ErrorDetails errorDetails;
    private final String id;
    private final String status;

    private JobEntity(Builder builder) {
        this.error = builder.error;
        this.errorDetails = builder.errorDetails;
        this.id = builder.id;
        this.status = builder.status;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="error_details")
    @Nullable
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JobEntity && this.equalTo((JobEntity)another);
    }

    private boolean equalTo(JobEntity another) {
        return Objects.equals(this.error, another.error) && Objects.equals(this.errorDetails, another.errorDetails) && this.id.equals(another.id) && this.status.equals(another.status);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.error);
        h = h * 17 + Objects.hashCode(this.errorDetails);
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.status.hashCode();
        return h;
    }

    public String toString() {
        return "JobEntity{error=" + this.error + ", errorDetails=" + this.errorDetails + ", id=" + this.id + ", status=" + this.status + "}";
    }

    @Deprecated
    @JsonCreator
    static JobEntity fromJson(Json json) {
        Builder builder = JobEntity.builder();
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.errorDetails != null) {
            builder.errorDetails(json.errorDetails);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_STATUS = 2L;
        private long initBits = 3L;
        private String error;
        private ErrorDetails errorDetails;
        private String id;
        private String status;

        private Builder() {
        }

        public final Builder from(JobEntity instance) {
            return this.from((_JobEntity)instance);
        }

        final Builder from(_JobEntity instance) {
            ErrorDetails errorDetailsValue;
            Objects.requireNonNull(instance, "instance");
            String errorValue = instance.getError();
            if (errorValue != null) {
                this.error(errorValue);
            }
            if ((errorDetailsValue = instance.getErrorDetails()) != null) {
                this.errorDetails(errorDetailsValue);
            }
            this.id(instance.getId());
            this.status(instance.getStatus());
            return this;
        }

        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        public final Builder errorDetails(@Nullable ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public JobEntity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new JobEntity(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build JobEntity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _JobEntity {
        String error;
        ErrorDetails errorDetails;
        String id;
        String status;

        Json() {
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="error_details")
        public void setErrorDetails(@Nullable ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ErrorDetails getErrorDetails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatus() {
            throw new UnsupportedOperationException();
        }
    }
}

