/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizationquotadefinitions;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.organizationquotadefinitions._CreateOrganizationQuotaDefinitionRequest;

public final class CreateOrganizationQuotaDefinitionRequest
extends _CreateOrganizationQuotaDefinitionRequest {
    @Nullable
    private final Integer applicationInstanceLimit;
    @Nullable
    private final Integer applicationTaskLimit;
    private final Integer instanceMemoryLimit;
    private final Integer memoryLimit;
    private final String name;
    private final Boolean nonBasicServicesAllowed;
    @Nullable
    private final Integer totalPrivateDomains;
    private final Integer totalRoutes;
    @Nullable
    private final Integer totalServiceKeys;
    private final Integer totalServices;
    @Nullable
    private final Boolean trialDatabaseAllowed;

    private CreateOrganizationQuotaDefinitionRequest(Builder builder) {
        this.applicationInstanceLimit = builder.applicationInstanceLimit;
        this.applicationTaskLimit = builder.applicationTaskLimit;
        this.instanceMemoryLimit = builder.instanceMemoryLimit;
        this.memoryLimit = builder.memoryLimit;
        this.name = builder.name;
        this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
        this.totalPrivateDomains = builder.totalPrivateDomains;
        this.totalRoutes = builder.totalRoutes;
        this.totalServiceKeys = builder.totalServiceKeys;
        this.totalServices = builder.totalServices;
        this.trialDatabaseAllowed = builder.trialDatabaseAllowed;
    }

    @Override
    @Nullable
    public Integer getApplicationInstanceLimit() {
        return this.applicationInstanceLimit;
    }

    @Override
    @Nullable
    public Integer getApplicationTaskLimit() {
        return this.applicationTaskLimit;
    }

    @Override
    public Integer getInstanceMemoryLimit() {
        return this.instanceMemoryLimit;
    }

    @Override
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean getNonBasicServicesAllowed() {
        return this.nonBasicServicesAllowed;
    }

    @Override
    @Nullable
    public Integer getTotalPrivateDomains() {
        return this.totalPrivateDomains;
    }

    @Override
    public Integer getTotalRoutes() {
        return this.totalRoutes;
    }

    @Override
    @Nullable
    public Integer getTotalServiceKeys() {
        return this.totalServiceKeys;
    }

    @Override
    public Integer getTotalServices() {
        return this.totalServices;
    }

    @Override
    @Deprecated
    @Nullable
    public Boolean getTrialDatabaseAllowed() {
        return this.trialDatabaseAllowed;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateOrganizationQuotaDefinitionRequest && this.equalTo((CreateOrganizationQuotaDefinitionRequest)another);
    }

    private boolean equalTo(CreateOrganizationQuotaDefinitionRequest another) {
        return Objects.equals(this.applicationInstanceLimit, another.applicationInstanceLimit) && Objects.equals(this.applicationTaskLimit, another.applicationTaskLimit) && this.instanceMemoryLimit.equals(another.instanceMemoryLimit) && this.memoryLimit.equals(another.memoryLimit) && this.name.equals(another.name) && this.nonBasicServicesAllowed.equals(another.nonBasicServicesAllowed) && Objects.equals(this.totalPrivateDomains, another.totalPrivateDomains) && this.totalRoutes.equals(another.totalRoutes) && Objects.equals(this.totalServiceKeys, another.totalServiceKeys) && this.totalServices.equals(another.totalServices) && Objects.equals(this.trialDatabaseAllowed, another.trialDatabaseAllowed);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.applicationInstanceLimit);
        h = h * 17 + Objects.hashCode(this.applicationTaskLimit);
        h = h * 17 + this.instanceMemoryLimit.hashCode();
        h = h * 17 + this.memoryLimit.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.nonBasicServicesAllowed.hashCode();
        h = h * 17 + Objects.hashCode(this.totalPrivateDomains);
        h = h * 17 + this.totalRoutes.hashCode();
        h = h * 17 + Objects.hashCode(this.totalServiceKeys);
        h = h * 17 + this.totalServices.hashCode();
        h = h * 17 + Objects.hashCode(this.trialDatabaseAllowed);
        return h;
    }

    public String toString() {
        return "CreateOrganizationQuotaDefinitionRequest{applicationInstanceLimit=" + this.applicationInstanceLimit + ", applicationTaskLimit=" + this.applicationTaskLimit + ", instanceMemoryLimit=" + this.instanceMemoryLimit + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", nonBasicServicesAllowed=" + this.nonBasicServicesAllowed + ", totalPrivateDomains=" + this.totalPrivateDomains + ", totalRoutes=" + this.totalRoutes + ", totalServiceKeys=" + this.totalServiceKeys + ", totalServices=" + this.totalServices + ", trialDatabaseAllowed=" + this.trialDatabaseAllowed + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_INSTANCE_MEMORY_LIMIT = 1L;
        private static final long INIT_BIT_MEMORY_LIMIT = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_NON_BASIC_SERVICES_ALLOWED = 8L;
        private static final long INIT_BIT_TOTAL_ROUTES = 16L;
        private static final long INIT_BIT_TOTAL_SERVICES = 32L;
        private long initBits = 63L;
        private Integer applicationInstanceLimit;
        private Integer applicationTaskLimit;
        private Integer instanceMemoryLimit;
        private Integer memoryLimit;
        private String name;
        private Boolean nonBasicServicesAllowed;
        private Integer totalPrivateDomains;
        private Integer totalRoutes;
        private Integer totalServiceKeys;
        private Integer totalServices;
        private Boolean trialDatabaseAllowed;

        private Builder() {
        }

        public final Builder from(CreateOrganizationQuotaDefinitionRequest instance) {
            return this.from((_CreateOrganizationQuotaDefinitionRequest)instance);
        }

        final Builder from(_CreateOrganizationQuotaDefinitionRequest instance) {
            Integer applicationTaskLimitValue;
            Objects.requireNonNull(instance, "instance");
            Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
            if (applicationInstanceLimitValue != null) {
                this.applicationInstanceLimit(applicationInstanceLimitValue);
            }
            if ((applicationTaskLimitValue = instance.getApplicationTaskLimit()) != null) {
                this.applicationTaskLimit(applicationTaskLimitValue);
            }
            this.instanceMemoryLimit(instance.getInstanceMemoryLimit());
            this.memoryLimit(instance.getMemoryLimit());
            this.name(instance.getName());
            this.nonBasicServicesAllowed(instance.getNonBasicServicesAllowed());
            Integer totalPrivateDomainsValue = instance.getTotalPrivateDomains();
            if (totalPrivateDomainsValue != null) {
                this.totalPrivateDomains(totalPrivateDomainsValue);
            }
            this.totalRoutes(instance.getTotalRoutes());
            Integer totalServiceKeysValue = instance.getTotalServiceKeys();
            if (totalServiceKeysValue != null) {
                this.totalServiceKeys(totalServiceKeysValue);
            }
            this.totalServices(instance.getTotalServices());
            Boolean trialDatabaseAllowedValue = instance.getTrialDatabaseAllowed();
            if (trialDatabaseAllowedValue != null) {
                this.trialDatabaseAllowed(trialDatabaseAllowedValue);
            }
            return this;
        }

        public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
            this.applicationInstanceLimit = applicationInstanceLimit;
            return this;
        }

        public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
            this.applicationTaskLimit = applicationTaskLimit;
            return this;
        }

        public final Builder instanceMemoryLimit(Integer instanceMemoryLimit) {
            this.instanceMemoryLimit = Objects.requireNonNull(instanceMemoryLimit, "instanceMemoryLimit");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder memoryLimit(Integer memoryLimit) {
            this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder nonBasicServicesAllowed(Boolean nonBasicServicesAllowed) {
            this.nonBasicServicesAllowed = Objects.requireNonNull(nonBasicServicesAllowed, "nonBasicServicesAllowed");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder totalPrivateDomains(@Nullable Integer totalPrivateDomains) {
            this.totalPrivateDomains = totalPrivateDomains;
            return this;
        }

        public final Builder totalRoutes(Integer totalRoutes) {
            this.totalRoutes = Objects.requireNonNull(totalRoutes, "totalRoutes");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
            this.totalServiceKeys = totalServiceKeys;
            return this;
        }

        public final Builder totalServices(Integer totalServices) {
            this.totalServices = Objects.requireNonNull(totalServices, "totalServices");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @Deprecated
        public final Builder trialDatabaseAllowed(@Nullable Boolean trialDatabaseAllowed) {
            this.trialDatabaseAllowed = trialDatabaseAllowed;
            return this;
        }

        public CreateOrganizationQuotaDefinitionRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateOrganizationQuotaDefinitionRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("instanceMemoryLimit");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("memoryLimit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("nonBasicServicesAllowed");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("totalRoutes");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("totalServices");
            }
            return "Cannot build CreateOrganizationQuotaDefinitionRequest, some of required attributes are not set " + attributes;
        }
    }
}

