/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizationquotadefinitions;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.organizationquotadefinitions._UpdateOrganizationQuotaDefinitionRequest;

public final class UpdateOrganizationQuotaDefinitionRequest
extends _UpdateOrganizationQuotaDefinitionRequest {
    @Nullable
    private final Integer applicationInstanceLimit;
    @Nullable
    private final Integer applicationTaskLimit;
    @Nullable
    private final Integer instanceMemoryLimit;
    @Nullable
    private final Integer memoryLimit;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean nonBasicServicesAllowed;
    private final String organizationQuotaDefinitionId;
    @Nullable
    private final Integer totalPrivateDomains;
    @Nullable
    private final Integer totalRoutes;
    @Nullable
    private final Integer totalServiceKeys;
    @Nullable
    private final Integer totalServices;
    @Nullable
    private final Boolean trialDatabaseAllowed;

    private UpdateOrganizationQuotaDefinitionRequest(Builder builder) {
        this.applicationInstanceLimit = builder.applicationInstanceLimit;
        this.applicationTaskLimit = builder.applicationTaskLimit;
        this.instanceMemoryLimit = builder.instanceMemoryLimit;
        this.memoryLimit = builder.memoryLimit;
        this.name = builder.name;
        this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
        this.organizationQuotaDefinitionId = builder.organizationQuotaDefinitionId;
        this.totalPrivateDomains = builder.totalPrivateDomains;
        this.totalRoutes = builder.totalRoutes;
        this.totalServiceKeys = builder.totalServiceKeys;
        this.totalServices = builder.totalServices;
        this.trialDatabaseAllowed = builder.trialDatabaseAllowed;
    }

    @Override
    @Nullable
    public Integer getApplicationInstanceLimit() {
        return this.applicationInstanceLimit;
    }

    @Override
    @Nullable
    public Integer getApplicationTaskLimit() {
        return this.applicationTaskLimit;
    }

    @Override
    @Nullable
    public Integer getInstanceMemoryLimit() {
        return this.instanceMemoryLimit;
    }

    @Override
    @Nullable
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean getNonBasicServicesAllowed() {
        return this.nonBasicServicesAllowed;
    }

    @Override
    public String getOrganizationQuotaDefinitionId() {
        return this.organizationQuotaDefinitionId;
    }

    @Override
    @Nullable
    public Integer getTotalPrivateDomains() {
        return this.totalPrivateDomains;
    }

    @Override
    @Nullable
    public Integer getTotalRoutes() {
        return this.totalRoutes;
    }

    @Override
    @Nullable
    public Integer getTotalServiceKeys() {
        return this.totalServiceKeys;
    }

    @Override
    @Nullable
    public Integer getTotalServices() {
        return this.totalServices;
    }

    @Override
    @Deprecated
    @Nullable
    public Boolean getTrialDatabaseAllowed() {
        return this.trialDatabaseAllowed;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateOrganizationQuotaDefinitionRequest && this.equalTo((UpdateOrganizationQuotaDefinitionRequest)another);
    }

    private boolean equalTo(UpdateOrganizationQuotaDefinitionRequest another) {
        return Objects.equals(this.applicationInstanceLimit, another.applicationInstanceLimit) && Objects.equals(this.applicationTaskLimit, another.applicationTaskLimit) && Objects.equals(this.instanceMemoryLimit, another.instanceMemoryLimit) && Objects.equals(this.memoryLimit, another.memoryLimit) && Objects.equals(this.name, another.name) && Objects.equals(this.nonBasicServicesAllowed, another.nonBasicServicesAllowed) && this.organizationQuotaDefinitionId.equals(another.organizationQuotaDefinitionId) && Objects.equals(this.totalPrivateDomains, another.totalPrivateDomains) && Objects.equals(this.totalRoutes, another.totalRoutes) && Objects.equals(this.totalServiceKeys, another.totalServiceKeys) && Objects.equals(this.totalServices, another.totalServices) && Objects.equals(this.trialDatabaseAllowed, another.trialDatabaseAllowed);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.applicationInstanceLimit);
        h = h * 17 + Objects.hashCode(this.applicationTaskLimit);
        h = h * 17 + Objects.hashCode(this.instanceMemoryLimit);
        h = h * 17 + Objects.hashCode(this.memoryLimit);
        h = h * 17 + Objects.hashCode(this.name);
        h = h * 17 + Objects.hashCode(this.nonBasicServicesAllowed);
        h = h * 17 + this.organizationQuotaDefinitionId.hashCode();
        h = h * 17 + Objects.hashCode(this.totalPrivateDomains);
        h = h * 17 + Objects.hashCode(this.totalRoutes);
        h = h * 17 + Objects.hashCode(this.totalServiceKeys);
        h = h * 17 + Objects.hashCode(this.totalServices);
        h = h * 17 + Objects.hashCode(this.trialDatabaseAllowed);
        return h;
    }

    public String toString() {
        return "UpdateOrganizationQuotaDefinitionRequest{applicationInstanceLimit=" + this.applicationInstanceLimit + ", applicationTaskLimit=" + this.applicationTaskLimit + ", instanceMemoryLimit=" + this.instanceMemoryLimit + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", nonBasicServicesAllowed=" + this.nonBasicServicesAllowed + ", organizationQuotaDefinitionId=" + this.organizationQuotaDefinitionId + ", totalPrivateDomains=" + this.totalPrivateDomains + ", totalRoutes=" + this.totalRoutes + ", totalServiceKeys=" + this.totalServiceKeys + ", totalServices=" + this.totalServices + ", trialDatabaseAllowed=" + this.trialDatabaseAllowed + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID = 1L;
        private long initBits = 1L;
        private Integer applicationInstanceLimit;
        private Integer applicationTaskLimit;
        private Integer instanceMemoryLimit;
        private Integer memoryLimit;
        private String name;
        private Boolean nonBasicServicesAllowed;
        private String organizationQuotaDefinitionId;
        private Integer totalPrivateDomains;
        private Integer totalRoutes;
        private Integer totalServiceKeys;
        private Integer totalServices;
        private Boolean trialDatabaseAllowed;

        private Builder() {
        }

        public final Builder from(UpdateOrganizationQuotaDefinitionRequest instance) {
            return this.from((_UpdateOrganizationQuotaDefinitionRequest)instance);
        }

        final Builder from(_UpdateOrganizationQuotaDefinitionRequest instance) {
            Boolean trialDatabaseAllowedValue;
            Integer totalServicesValue;
            Integer totalServiceKeysValue;
            Integer totalRoutesValue;
            Boolean nonBasicServicesAllowedValue;
            String nameValue;
            Integer memoryLimitValue;
            Integer instanceMemoryLimitValue;
            Integer applicationTaskLimitValue;
            Objects.requireNonNull(instance, "instance");
            Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
            if (applicationInstanceLimitValue != null) {
                this.applicationInstanceLimit(applicationInstanceLimitValue);
            }
            if ((applicationTaskLimitValue = instance.getApplicationTaskLimit()) != null) {
                this.applicationTaskLimit(applicationTaskLimitValue);
            }
            if ((instanceMemoryLimitValue = instance.getInstanceMemoryLimit()) != null) {
                this.instanceMemoryLimit(instanceMemoryLimitValue);
            }
            if ((memoryLimitValue = instance.getMemoryLimit()) != null) {
                this.memoryLimit(memoryLimitValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((nonBasicServicesAllowedValue = instance.getNonBasicServicesAllowed()) != null) {
                this.nonBasicServicesAllowed(nonBasicServicesAllowedValue);
            }
            this.organizationQuotaDefinitionId(instance.getOrganizationQuotaDefinitionId());
            Integer totalPrivateDomainsValue = instance.getTotalPrivateDomains();
            if (totalPrivateDomainsValue != null) {
                this.totalPrivateDomains(totalPrivateDomainsValue);
            }
            if ((totalRoutesValue = instance.getTotalRoutes()) != null) {
                this.totalRoutes(totalRoutesValue);
            }
            if ((totalServiceKeysValue = instance.getTotalServiceKeys()) != null) {
                this.totalServiceKeys(totalServiceKeysValue);
            }
            if ((totalServicesValue = instance.getTotalServices()) != null) {
                this.totalServices(totalServicesValue);
            }
            if ((trialDatabaseAllowedValue = instance.getTrialDatabaseAllowed()) != null) {
                this.trialDatabaseAllowed(trialDatabaseAllowedValue);
            }
            return this;
        }

        public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
            this.applicationInstanceLimit = applicationInstanceLimit;
            return this;
        }

        public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
            this.applicationTaskLimit = applicationTaskLimit;
            return this;
        }

        public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
            this.instanceMemoryLimit = instanceMemoryLimit;
            return this;
        }

        public final Builder memoryLimit(@Nullable Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder nonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
            this.nonBasicServicesAllowed = nonBasicServicesAllowed;
            return this;
        }

        public final Builder organizationQuotaDefinitionId(String organizationQuotaDefinitionId) {
            this.organizationQuotaDefinitionId = Objects.requireNonNull(organizationQuotaDefinitionId, "organizationQuotaDefinitionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder totalPrivateDomains(@Nullable Integer totalPrivateDomains) {
            this.totalPrivateDomains = totalPrivateDomains;
            return this;
        }

        public final Builder totalRoutes(@Nullable Integer totalRoutes) {
            this.totalRoutes = totalRoutes;
            return this;
        }

        public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
            this.totalServiceKeys = totalServiceKeys;
            return this;
        }

        public final Builder totalServices(@Nullable Integer totalServices) {
            this.totalServices = totalServices;
            return this;
        }

        @Deprecated
        public final Builder trialDatabaseAllowed(@Nullable Boolean trialDatabaseAllowed) {
            this.trialDatabaseAllowed = trialDatabaseAllowed;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateOrganizationQuotaDefinitionRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationQuotaDefinitionId");
            }
            return "Cannot build UpdateOrganizationQuotaDefinitionRequest, some of required attributes are not set " + attributes;
        }
    }
}

