/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.cloudfoundry.client.v2.organizations.OrganizationEntity;
import org.cloudfoundry.client.v2.organizations._AssociateOrganizationUserResponse;

public final class AssociateOrganizationUserResponse
extends _AssociateOrganizationUserResponse {
    @Nullable
    private final OrganizationEntity entity;
    @Nullable
    private final Metadata metadata;

    private AssociateOrganizationUserResponse(Builder builder) {
        this.entity = builder.entity;
        this.metadata = builder.metadata;
    }

    @Override
    @JsonProperty(value="entity")
    @Nullable
    public OrganizationEntity getEntity() {
        return this.entity;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AssociateOrganizationUserResponse && this.equalTo((AssociateOrganizationUserResponse)another);
    }

    private boolean equalTo(AssociateOrganizationUserResponse another) {
        return Objects.equals(this.entity, another.entity) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.entity);
        h = h * 17 + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "AssociateOrganizationUserResponse{entity=" + this.entity + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator
    static AssociateOrganizationUserResponse fromJson(Json json) {
        Builder builder = AssociateOrganizationUserResponse.builder();
        if (json.entity != null) {
            builder.entity(json.entity);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OrganizationEntity entity;
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(AssociateOrganizationUserResponse instance) {
            return this.from((_AssociateOrganizationUserResponse)instance);
        }

        final Builder from(_AssociateOrganizationUserResponse instance) {
            Metadata metadataValue;
            Objects.requireNonNull(instance, "instance");
            OrganizationEntity entityValue = (OrganizationEntity)instance.getEntity();
            if (entityValue != null) {
                this.entity(entityValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        public final Builder entity(@Nullable OrganizationEntity entity) {
            this.entity = entity;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public AssociateOrganizationUserResponse build() {
            return new AssociateOrganizationUserResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _AssociateOrganizationUserResponse {
        OrganizationEntity entity;
        Metadata metadata;

        Json() {
        }

        @JsonProperty(value="entity")
        public void setEntity(@Nullable OrganizationEntity entity) {
            this.entity = entity;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public OrganizationEntity getEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

