/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.organizations._CreateOrganizationRequest;

public final class CreateOrganizationRequest
extends _CreateOrganizationRequest {
    private final String name;
    @Nullable
    private final String quotaDefinitionId;
    @Nullable
    private final String status;

    private CreateOrganizationRequest(Builder builder) {
        this.name = builder.name;
        this.quotaDefinitionId = builder.quotaDefinitionId;
        this.status = builder.status;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getQuotaDefinitionId() {
        return this.quotaDefinitionId;
    }

    @Override
    @Nullable
    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateOrganizationRequest && this.equalTo((CreateOrganizationRequest)another);
    }

    private boolean equalTo(CreateOrganizationRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.quotaDefinitionId, another.quotaDefinitionId) && Objects.equals(this.status, another.status);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.quotaDefinitionId);
        h = h * 17 + Objects.hashCode(this.status);
        return h;
    }

    public String toString() {
        return "CreateOrganizationRequest{name=" + this.name + ", quotaDefinitionId=" + this.quotaDefinitionId + ", status=" + this.status + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private String quotaDefinitionId;
        private String status;

        private Builder() {
        }

        public final Builder from(CreateOrganizationRequest instance) {
            return this.from((_CreateOrganizationRequest)instance);
        }

        final Builder from(_CreateOrganizationRequest instance) {
            String statusValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            String quotaDefinitionIdValue = instance.getQuotaDefinitionId();
            if (quotaDefinitionIdValue != null) {
                this.quotaDefinitionId(quotaDefinitionIdValue);
            }
            if ((statusValue = instance.getStatus()) != null) {
                this.status(statusValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder quotaDefinitionId(@Nullable String quotaDefinitionId) {
            this.quotaDefinitionId = quotaDefinitionId;
            return this;
        }

        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public CreateOrganizationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateOrganizationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateOrganizationRequest, some of required attributes are not set " + attributes;
        }
    }
}

