/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.organizations._ListOrganizationManagersRequest;

public final class ListOrganizationManagersRequest
extends _ListOrganizationManagersRequest {
    @Nullable
    private final List<String> auditedOrganizationIds;
    @Nullable
    private final List<String> auditedSpaceIds;
    @Nullable
    private final List<String> billingManagedOrganizationIds;
    @Nullable
    private final List<String> managedOrganizationIds;
    @Nullable
    private final List<String> managedSpaceIds;
    private final String organizationId;
    @Nullable
    private final List<String> spaceIds;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListOrganizationManagersRequest(Builder builder) {
        this.auditedOrganizationIds = builder.auditedOrganizationIds == null ? null : ListOrganizationManagersRequest.createUnmodifiableList(true, builder.auditedOrganizationIds);
        this.auditedSpaceIds = builder.auditedSpaceIds == null ? null : ListOrganizationManagersRequest.createUnmodifiableList(true, builder.auditedSpaceIds);
        this.billingManagedOrganizationIds = builder.billingManagedOrganizationIds == null ? null : ListOrganizationManagersRequest.createUnmodifiableList(true, builder.billingManagedOrganizationIds);
        this.managedOrganizationIds = builder.managedOrganizationIds == null ? null : ListOrganizationManagersRequest.createUnmodifiableList(true, builder.managedOrganizationIds);
        this.managedSpaceIds = builder.managedSpaceIds == null ? null : ListOrganizationManagersRequest.createUnmodifiableList(true, builder.managedSpaceIds);
        this.organizationId = builder.organizationId;
        this.spaceIds = builder.spaceIds == null ? null : ListOrganizationManagersRequest.createUnmodifiableList(true, builder.spaceIds);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getAuditedOrganizationIds() {
        return this.auditedOrganizationIds;
    }

    @Override
    @Nullable
    public List<String> getAuditedSpaceIds() {
        return this.auditedSpaceIds;
    }

    @Override
    @Nullable
    public List<String> getBillingManagedOrganizationIds() {
        return this.billingManagedOrganizationIds;
    }

    @Override
    @Nullable
    public List<String> getManagedOrganizationIds() {
        return this.managedOrganizationIds;
    }

    @Override
    @Nullable
    public List<String> getManagedSpaceIds() {
        return this.managedSpaceIds;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @Nullable
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListOrganizationManagersRequest && this.equalTo((ListOrganizationManagersRequest)another);
    }

    private boolean equalTo(ListOrganizationManagersRequest another) {
        return Objects.equals(this.auditedOrganizationIds, another.auditedOrganizationIds) && Objects.equals(this.auditedSpaceIds, another.auditedSpaceIds) && Objects.equals(this.billingManagedOrganizationIds, another.billingManagedOrganizationIds) && Objects.equals(this.managedOrganizationIds, another.managedOrganizationIds) && Objects.equals(this.managedSpaceIds, another.managedSpaceIds) && this.organizationId.equals(another.organizationId) && Objects.equals(this.spaceIds, another.spaceIds) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.auditedOrganizationIds);
        h = h * 17 + Objects.hashCode(this.auditedSpaceIds);
        h = h * 17 + Objects.hashCode(this.billingManagedOrganizationIds);
        h = h * 17 + Objects.hashCode(this.managedOrganizationIds);
        h = h * 17 + Objects.hashCode(this.managedSpaceIds);
        h = h * 17 + this.organizationId.hashCode();
        h = h * 17 + Objects.hashCode(this.spaceIds);
        h = h * 17 + Objects.hashCode((Object)this.orderDirection);
        h = h * 17 + Objects.hashCode(this.page);
        h = h * 17 + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListOrganizationManagersRequest{auditedOrganizationIds=" + this.auditedOrganizationIds + ", auditedSpaceIds=" + this.auditedSpaceIds + ", billingManagedOrganizationIds=" + this.billingManagedOrganizationIds + ", managedOrganizationIds=" + this.managedOrganizationIds + ", managedSpaceIds=" + this.managedSpaceIds + ", organizationId=" + this.organizationId + ", spaceIds=" + this.spaceIds + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private long initBits = 1L;
        private List<String> auditedOrganizationIds = null;
        private List<String> auditedSpaceIds = null;
        private List<String> billingManagedOrganizationIds = null;
        private List<String> managedOrganizationIds = null;
        private List<String> managedSpaceIds = null;
        private String organizationId;
        private List<String> spaceIds = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListOrganizationManagersRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListOrganizationManagersRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListOrganizationManagersRequest) {
                List<String> managedSpaceIdsValue;
                List<String> billingManagedOrganizationIdsValue;
                List<String> spaceIdsValue;
                List<String> auditedSpaceIdsValue;
                List<String> managedOrganizationIdsValue;
                instance = (_ListOrganizationManagersRequest)object;
                this.organizationId(((_ListOrganizationManagersRequest)instance).getOrganizationId());
                List<String> auditedOrganizationIdsValue = ((_ListOrganizationManagersRequest)instance).getAuditedOrganizationIds();
                if (auditedOrganizationIdsValue != null) {
                    this.addAllAuditedOrganizationIds(auditedOrganizationIdsValue);
                }
                if ((managedOrganizationIdsValue = ((_ListOrganizationManagersRequest)instance).getManagedOrganizationIds()) != null) {
                    this.addAllManagedOrganizationIds(managedOrganizationIdsValue);
                }
                if ((auditedSpaceIdsValue = ((_ListOrganizationManagersRequest)instance).getAuditedSpaceIds()) != null) {
                    this.addAllAuditedSpaceIds(auditedSpaceIdsValue);
                }
                if ((spaceIdsValue = ((_ListOrganizationManagersRequest)instance).getSpaceIds()) != null) {
                    this.addAllSpaceIds(spaceIdsValue);
                }
                if ((billingManagedOrganizationIdsValue = ((_ListOrganizationManagersRequest)instance).getBillingManagedOrganizationIds()) != null) {
                    this.addAllBillingManagedOrganizationIds(billingManagedOrganizationIdsValue);
                }
                if ((managedSpaceIdsValue = ((_ListOrganizationManagersRequest)instance).getManagedSpaceIds()) != null) {
                    this.addAllManagedSpaceIds(managedSpaceIdsValue);
                }
            }
        }

        public final Builder auditedOrganizationId(String element) {
            if (this.auditedOrganizationIds == null) {
                this.auditedOrganizationIds = new ArrayList<String>();
            }
            this.auditedOrganizationIds.add(Objects.requireNonNull(element, "auditedOrganizationIds element"));
            return this;
        }

        public final Builder auditedOrganizationId(String ... elements) {
            if (this.auditedOrganizationIds == null) {
                this.auditedOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.auditedOrganizationIds.add(Objects.requireNonNull(element, "auditedOrganizationIds element"));
            }
            return this;
        }

        public final Builder auditedOrganizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.auditedOrganizationIds = null;
                return this;
            }
            this.auditedOrganizationIds = new ArrayList<String>();
            return this.addAllAuditedOrganizationIds(elements);
        }

        public final Builder addAllAuditedOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "auditedOrganizationIds element");
            if (this.auditedOrganizationIds == null) {
                this.auditedOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.auditedOrganizationIds.add(Objects.requireNonNull(element, "auditedOrganizationIds element"));
            }
            return this;
        }

        public final Builder auditedSpaceId(String element) {
            if (this.auditedSpaceIds == null) {
                this.auditedSpaceIds = new ArrayList<String>();
            }
            this.auditedSpaceIds.add(Objects.requireNonNull(element, "auditedSpaceIds element"));
            return this;
        }

        public final Builder auditedSpaceId(String ... elements) {
            if (this.auditedSpaceIds == null) {
                this.auditedSpaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.auditedSpaceIds.add(Objects.requireNonNull(element, "auditedSpaceIds element"));
            }
            return this;
        }

        public final Builder auditedSpaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.auditedSpaceIds = null;
                return this;
            }
            this.auditedSpaceIds = new ArrayList<String>();
            return this.addAllAuditedSpaceIds(elements);
        }

        public final Builder addAllAuditedSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "auditedSpaceIds element");
            if (this.auditedSpaceIds == null) {
                this.auditedSpaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.auditedSpaceIds.add(Objects.requireNonNull(element, "auditedSpaceIds element"));
            }
            return this;
        }

        public final Builder billingManagedOrganizationId(String element) {
            if (this.billingManagedOrganizationIds == null) {
                this.billingManagedOrganizationIds = new ArrayList<String>();
            }
            this.billingManagedOrganizationIds.add(Objects.requireNonNull(element, "billingManagedOrganizationIds element"));
            return this;
        }

        public final Builder billingManagedOrganizationId(String ... elements) {
            if (this.billingManagedOrganizationIds == null) {
                this.billingManagedOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.billingManagedOrganizationIds.add(Objects.requireNonNull(element, "billingManagedOrganizationIds element"));
            }
            return this;
        }

        public final Builder billingManagedOrganizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.billingManagedOrganizationIds = null;
                return this;
            }
            this.billingManagedOrganizationIds = new ArrayList<String>();
            return this.addAllBillingManagedOrganizationIds(elements);
        }

        public final Builder addAllBillingManagedOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "billingManagedOrganizationIds element");
            if (this.billingManagedOrganizationIds == null) {
                this.billingManagedOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.billingManagedOrganizationIds.add(Objects.requireNonNull(element, "billingManagedOrganizationIds element"));
            }
            return this;
        }

        public final Builder managedOrganizationId(String element) {
            if (this.managedOrganizationIds == null) {
                this.managedOrganizationIds = new ArrayList<String>();
            }
            this.managedOrganizationIds.add(Objects.requireNonNull(element, "managedOrganizationIds element"));
            return this;
        }

        public final Builder managedOrganizationId(String ... elements) {
            if (this.managedOrganizationIds == null) {
                this.managedOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.managedOrganizationIds.add(Objects.requireNonNull(element, "managedOrganizationIds element"));
            }
            return this;
        }

        public final Builder managedOrganizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.managedOrganizationIds = null;
                return this;
            }
            this.managedOrganizationIds = new ArrayList<String>();
            return this.addAllManagedOrganizationIds(elements);
        }

        public final Builder addAllManagedOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "managedOrganizationIds element");
            if (this.managedOrganizationIds == null) {
                this.managedOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.managedOrganizationIds.add(Objects.requireNonNull(element, "managedOrganizationIds element"));
            }
            return this;
        }

        public final Builder managedSpaceId(String element) {
            if (this.managedSpaceIds == null) {
                this.managedSpaceIds = new ArrayList<String>();
            }
            this.managedSpaceIds.add(Objects.requireNonNull(element, "managedSpaceIds element"));
            return this;
        }

        public final Builder managedSpaceId(String ... elements) {
            if (this.managedSpaceIds == null) {
                this.managedSpaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.managedSpaceIds.add(Objects.requireNonNull(element, "managedSpaceIds element"));
            }
            return this;
        }

        public final Builder managedSpaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.managedSpaceIds = null;
                return this;
            }
            this.managedSpaceIds = new ArrayList<String>();
            return this.addAllManagedSpaceIds(elements);
        }

        public final Builder addAllManagedSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "managedSpaceIds element");
            if (this.managedSpaceIds == null) {
                this.managedSpaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.managedSpaceIds.add(Objects.requireNonNull(element, "managedSpaceIds element"));
            }
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder spaceId(String element) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceId(String ... elements) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.spaceIds = null;
                return this;
            }
            this.spaceIds = new ArrayList<String>();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "spaceIds element");
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationManagersRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListOrganizationManagersRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build ListOrganizationManagersRequest, some of required attributes are not set " + attributes;
        }
    }
}

