/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.organizations._RemoveOrganizationManagerByUsernameRequest;

public final class RemoveOrganizationManagerByUsernameRequest
extends _RemoveOrganizationManagerByUsernameRequest {
    private final String organizationId;
    private final String username;

    private RemoveOrganizationManagerByUsernameRequest(Builder builder) {
        this.organizationId = builder.organizationId;
        this.username = builder.username;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RemoveOrganizationManagerByUsernameRequest && this.equalTo((RemoveOrganizationManagerByUsernameRequest)another);
    }

    private boolean equalTo(RemoveOrganizationManagerByUsernameRequest another) {
        return this.organizationId.equals(another.organizationId) && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.organizationId.hashCode();
        h = h * 17 + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "RemoveOrganizationManagerByUsernameRequest{organizationId=" + this.organizationId + ", username=" + this.username + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private static final long INIT_BIT_USERNAME = 2L;
        private long initBits = 3L;
        private String organizationId;
        private String username;

        private Builder() {
        }

        public final Builder from(RemoveOrganizationManagerByUsernameRequest instance) {
            return this.from((_RemoveOrganizationManagerByUsernameRequest)instance);
        }

        final Builder from(_RemoveOrganizationManagerByUsernameRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.organizationId(instance.getOrganizationId());
            this.username(instance.getUsername());
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public RemoveOrganizationManagerByUsernameRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RemoveOrganizationManagerByUsernameRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build RemoveOrganizationManagerByUsernameRequest, some of required attributes are not set " + attributes;
        }
    }
}

