/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.privatedomains;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.privatedomains._GetPrivateDomainRequest;

public final class GetPrivateDomainRequest
extends _GetPrivateDomainRequest {
    private final String privateDomainId;

    private GetPrivateDomainRequest(Builder builder) {
        this.privateDomainId = builder.privateDomainId;
    }

    @Override
    public String getPrivateDomainId() {
        return this.privateDomainId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetPrivateDomainRequest && this.equalTo((GetPrivateDomainRequest)another);
    }

    private boolean equalTo(GetPrivateDomainRequest another) {
        return this.privateDomainId.equals(another.privateDomainId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.privateDomainId.hashCode();
        return h;
    }

    public String toString() {
        return "GetPrivateDomainRequest{privateDomainId=" + this.privateDomainId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PRIVATE_DOMAIN_ID = 1L;
        private long initBits = 1L;
        private String privateDomainId;

        private Builder() {
        }

        public final Builder from(GetPrivateDomainRequest instance) {
            return this.from((_GetPrivateDomainRequest)instance);
        }

        final Builder from(_GetPrivateDomainRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.privateDomainId(instance.getPrivateDomainId());
            return this;
        }

        public final Builder privateDomainId(String privateDomainId) {
            this.privateDomainId = Objects.requireNonNull(privateDomainId, "privateDomainId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public GetPrivateDomainRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetPrivateDomainRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("privateDomainId");
            }
            return "Cannot build GetPrivateDomainRequest, some of required attributes are not set " + attributes;
        }
    }
}

