/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routemappings;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.routemappings._GetRouteMappingRequest;

public final class GetRouteMappingRequest
extends _GetRouteMappingRequest {
    private final String routeMappingId;

    private GetRouteMappingRequest(Builder builder) {
        this.routeMappingId = builder.routeMappingId;
    }

    @Override
    public String getRouteMappingId() {
        return this.routeMappingId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetRouteMappingRequest && this.equalTo((GetRouteMappingRequest)another);
    }

    private boolean equalTo(GetRouteMappingRequest another) {
        return this.routeMappingId.equals(another.routeMappingId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.routeMappingId.hashCode();
        return h;
    }

    public String toString() {
        return "GetRouteMappingRequest{routeMappingId=" + this.routeMappingId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ROUTE_MAPPING_ID = 1L;
        private long initBits = 1L;
        private String routeMappingId;

        private Builder() {
        }

        public final Builder from(GetRouteMappingRequest instance) {
            return this.from((_GetRouteMappingRequest)instance);
        }

        final Builder from(_GetRouteMappingRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.routeMappingId(instance.getRouteMappingId());
            return this;
        }

        public final Builder routeMappingId(String routeMappingId) {
            this.routeMappingId = Objects.requireNonNull(routeMappingId, "routeMappingId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public GetRouteMappingRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetRouteMappingRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("routeMappingId");
            }
            return "Cannot build GetRouteMappingRequest, some of required attributes are not set " + attributes;
        }
    }
}

