/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routemappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.routemappings._ListRouteMappingsRequest;

public final class ListRouteMappingsRequest
extends _ListRouteMappingsRequest {
    @Nullable
    private final List<String> applicationIds;
    @Nullable
    private final List<String> routeIds;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListRouteMappingsRequest(Builder builder) {
        this.applicationIds = builder.applicationIds == null ? null : ListRouteMappingsRequest.createUnmodifiableList(true, builder.applicationIds);
        this.routeIds = builder.routeIds == null ? null : ListRouteMappingsRequest.createUnmodifiableList(true, builder.routeIds);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    @Nullable
    public List<String> getRouteIds() {
        return this.routeIds;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListRouteMappingsRequest && this.equalTo((ListRouteMappingsRequest)another);
    }

    private boolean equalTo(ListRouteMappingsRequest another) {
        return Objects.equals(this.applicationIds, another.applicationIds) && Objects.equals(this.routeIds, another.routeIds) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.applicationIds);
        h = h * 17 + Objects.hashCode(this.routeIds);
        h = h * 17 + Objects.hashCode((Object)this.orderDirection);
        h = h * 17 + Objects.hashCode(this.page);
        h = h * 17 + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListRouteMappingsRequest{applicationIds=" + this.applicationIds + ", routeIds=" + this.routeIds + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> applicationIds = null;
        private List<String> routeIds = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(ListRouteMappingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListRouteMappingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListRouteMappingsRequest) {
                List<String> applicationIdsValue;
                instance = (_ListRouteMappingsRequest)object;
                List<String> routeIdsValue = ((_ListRouteMappingsRequest)instance).getRouteIds();
                if (routeIdsValue != null) {
                    this.addAllRouteIds(routeIdsValue);
                }
                if ((applicationIdsValue = ((_ListRouteMappingsRequest)instance).getApplicationIds()) != null) {
                    this.addAllApplicationIds(applicationIdsValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder applicationId(String element) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationId(String ... elements) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.applicationIds = null;
                return this;
            }
            this.applicationIds = new ArrayList<String>();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "applicationIds element");
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder routeId(String element) {
            if (this.routeIds == null) {
                this.routeIds = new ArrayList<String>();
            }
            this.routeIds.add(Objects.requireNonNull(element, "routeIds element"));
            return this;
        }

        public final Builder routeId(String ... elements) {
            if (this.routeIds == null) {
                this.routeIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.routeIds.add(Objects.requireNonNull(element, "routeIds element"));
            }
            return this;
        }

        public final Builder routeIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.routeIds = null;
                return this;
            }
            this.routeIds = new ArrayList<String>();
            return this.addAllRouteIds(elements);
        }

        public final Builder addAllRouteIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "routeIds element");
            if (this.routeIds == null) {
                this.routeIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.routeIds.add(Objects.requireNonNull(element, "routeIds element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListRouteMappingsRequest build() {
            return new ListRouteMappingsRequest(this);
        }
    }
}

