/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceusageevents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.serviceusageevents._ListServiceUsageEventsRequest;

public final class ListServiceUsageEventsRequest
extends _ListServiceUsageEventsRequest {
    @Nullable
    private final String afterServiceUsageEventId;
    @Nullable
    private final List<String> serviceIds;
    @Nullable
    private final List<String> serviceInstanceTypes;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListServiceUsageEventsRequest(Builder builder) {
        this.afterServiceUsageEventId = builder.afterServiceUsageEventId;
        this.serviceIds = builder.serviceIds == null ? null : ListServiceUsageEventsRequest.createUnmodifiableList(true, builder.serviceIds);
        this.serviceInstanceTypes = builder.serviceInstanceTypes == null ? null : ListServiceUsageEventsRequest.createUnmodifiableList(true, builder.serviceInstanceTypes);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public String getAfterServiceUsageEventId() {
        return this.afterServiceUsageEventId;
    }

    @Override
    @Nullable
    public List<String> getServiceIds() {
        return this.serviceIds;
    }

    @Override
    @Nullable
    public List<String> getServiceInstanceTypes() {
        return this.serviceInstanceTypes;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServiceUsageEventsRequest && this.equalTo((ListServiceUsageEventsRequest)another);
    }

    private boolean equalTo(ListServiceUsageEventsRequest another) {
        return Objects.equals(this.afterServiceUsageEventId, another.afterServiceUsageEventId) && Objects.equals(this.serviceIds, another.serviceIds) && Objects.equals(this.serviceInstanceTypes, another.serviceInstanceTypes) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.afterServiceUsageEventId);
        h = h * 17 + Objects.hashCode(this.serviceIds);
        h = h * 17 + Objects.hashCode(this.serviceInstanceTypes);
        h = h * 17 + Objects.hashCode((Object)this.orderDirection);
        h = h * 17 + Objects.hashCode(this.page);
        h = h * 17 + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListServiceUsageEventsRequest{afterServiceUsageEventId=" + this.afterServiceUsageEventId + ", serviceIds=" + this.serviceIds + ", serviceInstanceTypes=" + this.serviceInstanceTypes + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private String afterServiceUsageEventId;
        private List<String> serviceIds = null;
        private List<String> serviceInstanceTypes = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListServiceUsageEventsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListServiceUsageEventsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListServiceUsageEventsRequest) {
                String afterServiceUsageEventIdValue;
                List<String> serviceInstanceTypesValue;
                instance = (_ListServiceUsageEventsRequest)object;
                List<String> serviceIdsValue = ((_ListServiceUsageEventsRequest)instance).getServiceIds();
                if (serviceIdsValue != null) {
                    this.addAllServiceIds(serviceIdsValue);
                }
                if ((serviceInstanceTypesValue = ((_ListServiceUsageEventsRequest)instance).getServiceInstanceTypes()) != null) {
                    this.addAllServiceInstanceTypes(serviceInstanceTypesValue);
                }
                if ((afterServiceUsageEventIdValue = ((_ListServiceUsageEventsRequest)instance).getAfterServiceUsageEventId()) != null) {
                    this.afterServiceUsageEventId(afterServiceUsageEventIdValue);
                }
            }
        }

        public final Builder afterServiceUsageEventId(@Nullable String afterServiceUsageEventId) {
            this.afterServiceUsageEventId = afterServiceUsageEventId;
            return this;
        }

        public final Builder serviceId(String element) {
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList<String>();
            }
            this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
            return this;
        }

        public final Builder serviceId(String ... elements) {
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
            }
            return this;
        }

        public final Builder serviceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceIds = null;
                return this;
            }
            this.serviceIds = new ArrayList<String>();
            return this.addAllServiceIds(elements);
        }

        public final Builder addAllServiceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceIds element");
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceType(String element) {
            if (this.serviceInstanceTypes == null) {
                this.serviceInstanceTypes = new ArrayList<String>();
            }
            this.serviceInstanceTypes.add(Objects.requireNonNull(element, "serviceInstanceTypes element"));
            return this;
        }

        public final Builder serviceInstanceType(String ... elements) {
            if (this.serviceInstanceTypes == null) {
                this.serviceInstanceTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceInstanceTypes.add(Objects.requireNonNull(element, "serviceInstanceTypes element"));
            }
            return this;
        }

        public final Builder serviceInstanceTypes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceInstanceTypes = null;
                return this;
            }
            this.serviceInstanceTypes = new ArrayList<String>();
            return this.addAllServiceInstanceTypes(elements);
        }

        public final Builder addAllServiceInstanceTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceInstanceTypes element");
            if (this.serviceInstanceTypes == null) {
                this.serviceInstanceTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceInstanceTypes.add(Objects.requireNonNull(element, "serviceInstanceTypes element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServiceUsageEventsRequest build() {
            return new ListServiceUsageEventsRequest(this);
        }
    }
}

