/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.shareddomains;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.shareddomains._CreateSharedDomainRequest;

public final class CreateSharedDomainRequest
extends _CreateSharedDomainRequest {
    private final String name;
    @Nullable
    private final String routerGroupId;

    private CreateSharedDomainRequest(Builder builder) {
        this.name = builder.name;
        this.routerGroupId = builder.routerGroupId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getRouterGroupId() {
        return this.routerGroupId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateSharedDomainRequest && this.equalTo((CreateSharedDomainRequest)another);
    }

    private boolean equalTo(CreateSharedDomainRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.routerGroupId, another.routerGroupId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.routerGroupId);
        return h;
    }

    public String toString() {
        return "CreateSharedDomainRequest{name=" + this.name + ", routerGroupId=" + this.routerGroupId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private String routerGroupId;

        private Builder() {
        }

        public final Builder from(CreateSharedDomainRequest instance) {
            return this.from((_CreateSharedDomainRequest)instance);
        }

        final Builder from(_CreateSharedDomainRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            String routerGroupIdValue = instance.getRouterGroupId();
            if (routerGroupIdValue != null) {
                this.routerGroupId(routerGroupIdValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder routerGroupId(@Nullable String routerGroupId) {
            this.routerGroupId = routerGroupId;
            return this;
        }

        public CreateSharedDomainRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateSharedDomainRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateSharedDomainRequest, some of required attributes are not set " + attributes;
        }
    }
}

