/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.shareddomains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainEntity;
import org.cloudfoundry.client.v2.shareddomains._CreateSharedDomainResponse;

public final class CreateSharedDomainResponse
extends _CreateSharedDomainResponse {
    @Nullable
    private final SharedDomainEntity entity;
    @Nullable
    private final Metadata metadata;

    private CreateSharedDomainResponse(Builder builder) {
        this.entity = builder.entity;
        this.metadata = builder.metadata;
    }

    @Override
    @JsonProperty(value="entity")
    @Nullable
    public SharedDomainEntity getEntity() {
        return this.entity;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateSharedDomainResponse && this.equalTo((CreateSharedDomainResponse)another);
    }

    private boolean equalTo(CreateSharedDomainResponse another) {
        return Objects.equals(this.entity, another.entity) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.entity);
        h = h * 17 + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "CreateSharedDomainResponse{entity=" + this.entity + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator
    static CreateSharedDomainResponse fromJson(Json json) {
        Builder builder = CreateSharedDomainResponse.builder();
        if (json.entity != null) {
            builder.entity(json.entity);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SharedDomainEntity entity;
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(CreateSharedDomainResponse instance) {
            return this.from((_CreateSharedDomainResponse)instance);
        }

        final Builder from(_CreateSharedDomainResponse instance) {
            Metadata metadataValue;
            Objects.requireNonNull(instance, "instance");
            SharedDomainEntity entityValue = (SharedDomainEntity)instance.getEntity();
            if (entityValue != null) {
                this.entity(entityValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        public final Builder entity(@Nullable SharedDomainEntity entity) {
            this.entity = entity;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public CreateSharedDomainResponse build() {
            return new CreateSharedDomainResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _CreateSharedDomainResponse {
        SharedDomainEntity entity;
        Metadata metadata;

        Json() {
        }

        @JsonProperty(value="entity")
        public void setEntity(@Nullable SharedDomainEntity entity) {
            this.entity = entity;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public SharedDomainEntity getEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

