/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.shareddomains;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.shareddomains._ListSharedDomainsRequest;

public final class ListSharedDomainsRequest
extends _ListSharedDomainsRequest {
    @Nullable
    private final List<String> names;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListSharedDomainsRequest(Builder builder) {
        this.names = builder.names == null ? null : ListSharedDomainsRequest.createUnmodifiableList(true, builder.names);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListSharedDomainsRequest && this.equalTo((ListSharedDomainsRequest)another);
    }

    private boolean equalTo(ListSharedDomainsRequest another) {
        return Objects.equals(this.names, another.names) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.names);
        h = h * 17 + Objects.hashCode((Object)this.orderDirection);
        h = h * 17 + Objects.hashCode(this.page);
        h = h * 17 + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListSharedDomainsRequest{names=" + this.names + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> names = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListSharedDomainsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListSharedDomainsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            List<String> namesValue;
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListSharedDomainsRequest && (namesValue = ((_ListSharedDomainsRequest)(instance = (_ListSharedDomainsRequest)object)).getNames()) != null) {
                this.addAllNames(namesValue);
            }
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder name(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSharedDomainsRequest build() {
            return new ListSharedDomainsRequest(this);
        }
    }
}

