/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.shareddomains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainEntity;
import org.cloudfoundry.client.v2.shareddomains._SharedDomainResource;

public final class SharedDomainResource
extends _SharedDomainResource {
    @Nullable
    private final SharedDomainEntity entity;
    @Nullable
    private final Metadata metadata;

    private SharedDomainResource(Builder builder) {
        this.entity = builder.entity;
        this.metadata = builder.metadata;
    }

    @Override
    @JsonProperty(value="entity")
    @Nullable
    public SharedDomainEntity getEntity() {
        return this.entity;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SharedDomainResource && this.equalTo((SharedDomainResource)another);
    }

    private boolean equalTo(SharedDomainResource another) {
        return Objects.equals(this.entity, another.entity) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.entity);
        h = h * 17 + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "SharedDomainResource{entity=" + this.entity + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator
    static SharedDomainResource fromJson(Json json) {
        Builder builder = SharedDomainResource.builder();
        if (json.entity != null) {
            builder.entity(json.entity);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SharedDomainEntity entity;
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(SharedDomainResource instance) {
            return this.from((_SharedDomainResource)instance);
        }

        final Builder from(_SharedDomainResource instance) {
            Metadata metadataValue;
            Objects.requireNonNull(instance, "instance");
            SharedDomainEntity entityValue = (SharedDomainEntity)instance.getEntity();
            if (entityValue != null) {
                this.entity(entityValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        public final Builder entity(@Nullable SharedDomainEntity entity) {
            this.entity = entity;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public SharedDomainResource build() {
            return new SharedDomainResource(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _SharedDomainResource {
        SharedDomainEntity entity;
        Metadata metadata;

        Json() {
        }

        @JsonProperty(value="entity")
        public void setEntity(@Nullable SharedDomainEntity entity) {
            this.entity = entity;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public SharedDomainEntity getEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

