/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.cloudfoundry.client.v2.spaces._ListSpacesResponse;

public final class ListSpacesResponse
extends _ListSpacesResponse {
    @Nullable
    private final String nextUrl;
    @Nullable
    private final String previousUrl;
    @Nullable
    private final List<SpaceResource> resources;
    @Nullable
    private final Integer totalPages;
    @Nullable
    private final Integer totalResults;

    private ListSpacesResponse(Builder builder) {
        this.nextUrl = builder.nextUrl;
        this.previousUrl = builder.previousUrl;
        this.resources = builder.resources == null ? null : ListSpacesResponse.createUnmodifiableList(true, builder.resources);
        this.totalPages = builder.totalPages;
        this.totalResults = builder.totalResults;
    }

    @Override
    @JsonProperty(value="next_url")
    @Nullable
    public String getNextUrl() {
        return this.nextUrl;
    }

    @Override
    @JsonProperty(value="prev_url")
    @Nullable
    public String getPreviousUrl() {
        return this.previousUrl;
    }

    @Override
    @JsonProperty(value="resources")
    @Nullable
    public List<SpaceResource> getResources() {
        return this.resources;
    }

    @Override
    @JsonProperty(value="total_pages")
    @Nullable
    public Integer getTotalPages() {
        return this.totalPages;
    }

    @Override
    @JsonProperty(value="total_results")
    @Nullable
    public Integer getTotalResults() {
        return this.totalResults;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListSpacesResponse && this.equalTo((ListSpacesResponse)another);
    }

    private boolean equalTo(ListSpacesResponse another) {
        return Objects.equals(this.nextUrl, another.nextUrl) && Objects.equals(this.previousUrl, another.previousUrl) && Objects.equals(this.resources, another.resources) && Objects.equals(this.totalPages, another.totalPages) && Objects.equals(this.totalResults, another.totalResults);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.nextUrl);
        h = h * 17 + Objects.hashCode(this.previousUrl);
        h = h * 17 + Objects.hashCode(this.resources);
        h = h * 17 + Objects.hashCode(this.totalPages);
        h = h * 17 + Objects.hashCode(this.totalResults);
        return h;
    }

    public String toString() {
        return "ListSpacesResponse{nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + "}";
    }

    @Deprecated
    @JsonCreator
    static ListSpacesResponse fromJson(Json json) {
        Builder builder = ListSpacesResponse.builder();
        if (json.nextUrl != null) {
            builder.nextUrl(json.nextUrl);
        }
        if (json.previousUrl != null) {
            builder.previousUrl(json.previousUrl);
        }
        if (json.resources != null) {
            builder.addAllResources(json.resources);
        }
        if (json.totalPages != null) {
            builder.totalPages(json.totalPages);
        }
        if (json.totalResults != null) {
            builder.totalResults(json.totalResults);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private String nextUrl;
        private String previousUrl;
        private List<SpaceResource> resources = null;
        private Integer totalPages;
        private Integer totalResults;

        private Builder() {
        }

        public final Builder from(ListSpacesResponse instance) {
            return this.from((_ListSpacesResponse)instance);
        }

        final Builder from(_ListSpacesResponse instance) {
            Integer totalResultsValue;
            Integer totalPagesValue;
            List resourcesValue;
            String previousUrlValue;
            Objects.requireNonNull(instance, "instance");
            String nextUrlValue = instance.getNextUrl();
            if (nextUrlValue != null) {
                this.nextUrl(nextUrlValue);
            }
            if ((previousUrlValue = instance.getPreviousUrl()) != null) {
                this.previousUrl(previousUrlValue);
            }
            if ((resourcesValue = instance.getResources()) != null) {
                this.addAllResources(resourcesValue);
            }
            if ((totalPagesValue = instance.getTotalPages()) != null) {
                this.totalPages(totalPagesValue);
            }
            if ((totalResultsValue = instance.getTotalResults()) != null) {
                this.totalResults(totalResultsValue);
            }
            return this;
        }

        public final Builder nextUrl(@Nullable String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public final Builder previousUrl(@Nullable String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public final Builder resource(SpaceResource element) {
            if (this.resources == null) {
                this.resources = new ArrayList<SpaceResource>();
            }
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resource(SpaceResource ... elements) {
            if (this.resources == null) {
                this.resources = new ArrayList<SpaceResource>();
            }
            for (SpaceResource element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        public final Builder resources(@Nullable Iterable<? extends SpaceResource> elements) {
            if (elements == null) {
                this.resources = null;
                return this;
            }
            this.resources = new ArrayList<SpaceResource>();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends SpaceResource> elements) {
            Objects.requireNonNull(elements, "resources element");
            if (this.resources == null) {
                this.resources = new ArrayList<SpaceResource>();
            }
            for (SpaceResource spaceResource : elements) {
                this.resources.add(Objects.requireNonNull(spaceResource, "resources element"));
            }
            return this;
        }

        public final Builder totalPages(@Nullable Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public final Builder totalResults(@Nullable Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListSpacesResponse build() {
            return new ListSpacesResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ListSpacesResponse {
        String nextUrl;
        String previousUrl;
        List<SpaceResource> resources = null;
        Integer totalPages;
        Integer totalResults;

        Json() {
        }

        @JsonProperty(value="next_url")
        public void setNextUrl(@Nullable String nextUrl) {
            this.nextUrl = nextUrl;
        }

        @JsonProperty(value="prev_url")
        public void setPreviousUrl(@Nullable String previousUrl) {
            this.previousUrl = previousUrl;
        }

        @JsonProperty(value="resources")
        public void setResources(@Nullable List<SpaceResource> resources) {
            this.resources = resources;
        }

        @JsonProperty(value="total_pages")
        public void setTotalPages(@Nullable Integer totalPages) {
            this.totalPages = totalPages;
        }

        @JsonProperty(value="total_results")
        public void setTotalResults(@Nullable Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public String getNextUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPreviousUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SpaceResource> getResources() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getTotalPages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getTotalResults() {
            throw new UnsupportedOperationException();
        }
    }
}

