/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.stacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.stacks._StackEntity;

public final class StackEntity
extends _StackEntity {
    @Nullable
    private final String description;
    @Nullable
    private final String name;

    private StackEntity(Builder builder) {
        this.description = builder.description;
        this.name = builder.name;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StackEntity && this.equalTo((StackEntity)another);
    }

    private boolean equalTo(StackEntity another) {
        return Objects.equals(this.description, another.description) && Objects.equals(this.name, another.name);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + Objects.hashCode(this.name);
        return h;
    }

    public String toString() {
        return "StackEntity{description=" + this.description + ", name=" + this.name + "}";
    }

    @Deprecated
    @JsonCreator
    static StackEntity fromJson(Json json) {
        Builder builder = StackEntity.builder();
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String name;

        private Builder() {
        }

        public final Builder from(StackEntity instance) {
            return this.from((_StackEntity)instance);
        }

        final Builder from(_StackEntity instance) {
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                this.description(descriptionValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public StackEntity build() {
            return new StackEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _StackEntity {
        String description;
        String name;

        Json() {
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }
    }
}

