/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3._BuildpackData;

public final class BuildpackData
extends _BuildpackData {
    @Nullable
    private final String buildpack;
    @Nullable
    private final String stack;

    private BuildpackData(Builder builder) {
        this.buildpack = builder.buildpack;
        this.stack = builder.stack;
    }

    @Override
    @JsonProperty(value="buildpack")
    @Nullable
    public String getBuildpack() {
        return this.buildpack;
    }

    @Override
    @JsonProperty(value="stack")
    @Nullable
    public String getStack() {
        return this.stack;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BuildpackData && this.equalTo((BuildpackData)another);
    }

    private boolean equalTo(BuildpackData another) {
        return Objects.equals(this.buildpack, another.buildpack) && Objects.equals(this.stack, another.stack);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.buildpack);
        h = h * 17 + Objects.hashCode(this.stack);
        return h;
    }

    public String toString() {
        return "BuildpackData{buildpack=" + this.buildpack + ", stack=" + this.stack + "}";
    }

    @Deprecated
    @JsonCreator
    static BuildpackData fromJson(Json json) {
        Builder builder = BuildpackData.builder();
        if (json.buildpack != null) {
            builder.buildpack(json.buildpack);
        }
        if (json.stack != null) {
            builder.stack(json.stack);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String buildpack;
        private String stack;

        private Builder() {
        }

        public final Builder from(BuildpackData instance) {
            return this.from((_BuildpackData)instance);
        }

        final Builder from(_BuildpackData instance) {
            String stackValue;
            Objects.requireNonNull(instance, "instance");
            String buildpackValue = instance.getBuildpack();
            if (buildpackValue != null) {
                this.buildpack(buildpackValue);
            }
            if ((stackValue = instance.getStack()) != null) {
                this.stack(stackValue);
            }
            return this;
        }

        public final Builder buildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public final Builder stack(@Nullable String stack) {
            this.stack = stack;
            return this;
        }

        public BuildpackData build() {
            return new BuildpackData(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _BuildpackData {
        String buildpack;
        String stack;

        Json() {
        }

        @JsonProperty(value="buildpack")
        public void setBuildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
        }

        @JsonProperty(value="stack")
        public void setStack(@Nullable String stack) {
            this.stack = stack;
        }

        @Override
        public String getBuildpack() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStack() {
            throw new UnsupportedOperationException();
        }
    }
}

