/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3._Link;

public final class Link
extends _Link {
    @Nullable
    private final String href;
    @Nullable
    private final String method;

    private Link(Builder builder) {
        this.href = builder.href;
        this.method = builder.method;
    }

    @Override
    @JsonProperty(value="href")
    @Nullable
    public String getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="method")
    @Nullable
    public String getMethod() {
        return this.method;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Link && this.equalTo((Link)another);
    }

    private boolean equalTo(Link another) {
        return Objects.equals(this.href, another.href) && Objects.equals(this.method, another.method);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.href);
        h = h * 17 + Objects.hashCode(this.method);
        return h;
    }

    public String toString() {
        return "Link{href=" + this.href + ", method=" + this.method + "}";
    }

    @Deprecated
    @JsonCreator
    static Link fromJson(Json json) {
        Builder builder = Link.builder();
        if (json.href != null) {
            builder.href(json.href);
        }
        if (json.method != null) {
            builder.method(json.method);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String href;
        private String method;

        private Builder() {
        }

        public final Builder from(Link instance) {
            return this.from((_Link)instance);
        }

        final Builder from(_Link instance) {
            String methodValue;
            Objects.requireNonNull(instance, "instance");
            String hrefValue = instance.getHref();
            if (hrefValue != null) {
                this.href(hrefValue);
            }
            if ((methodValue = instance.getMethod()) != null) {
                this.method(methodValue);
            }
            return this;
        }

        public final Builder href(@Nullable String href) {
            this.href = href;
            return this;
        }

        public final Builder method(@Nullable String method) {
            this.method = method;
            return this;
        }

        public Link build() {
            return new Link(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Link {
        String href;
        String method;

        Json() {
        }

        @JsonProperty(value="href")
        public void setHref(@Nullable String href) {
            this.href = href;
        }

        @JsonProperty(value="method")
        public void setMethod(@Nullable String method) {
            this.method = method;
        }

        @Override
        public String getHref() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMethod() {
            throw new UnsupportedOperationException();
        }
    }
}

