/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3._Relationship;

public final class Relationship
extends _Relationship {
    private final String id;

    private Relationship(Builder builder) {
        this.id = builder.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Relationship && this.equalTo((Relationship)another);
    }

    private boolean equalTo(Relationship another) {
        return this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        return h;
    }

    public String toString() {
        return "Relationship{id=" + this.id + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        private String id;

        private Builder() {
        }

        public final Builder from(Relationship instance) {
            return this.from((_Relationship)instance);
        }

        final Builder from(_Relationship instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Relationship build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Relationship(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Relationship, some of required attributes are not set " + attributes;
        }
    }
}

