/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.applications._AssignApplicationDropletRequest;

public final class AssignApplicationDropletRequest
extends _AssignApplicationDropletRequest {
    private final String applicationId;
    private final String dropletId;

    private AssignApplicationDropletRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.dropletId = builder.dropletId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getDropletId() {
        return this.dropletId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AssignApplicationDropletRequest && this.equalTo((AssignApplicationDropletRequest)another);
    }

    private boolean equalTo(AssignApplicationDropletRequest another) {
        return this.applicationId.equals(another.applicationId) && this.dropletId.equals(another.dropletId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + this.dropletId.hashCode();
        return h;
    }

    public String toString() {
        return "AssignApplicationDropletRequest{applicationId=" + this.applicationId + ", dropletId=" + this.dropletId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_DROPLET_ID = 2L;
        private long initBits = 3L;
        private String applicationId;
        private String dropletId;

        private Builder() {
        }

        public final Builder from(AssignApplicationDropletRequest instance) {
            return this.from((_AssignApplicationDropletRequest)instance);
        }

        final Builder from(_AssignApplicationDropletRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.dropletId(instance.getDropletId());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder dropletId(String dropletId) {
            this.dropletId = Objects.requireNonNull(dropletId, "dropletId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AssignApplicationDropletRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AssignApplicationDropletRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dropletId");
            }
            return "Cannot build AssignApplicationDropletRequest, some of required attributes are not set " + attributes;
        }
    }
}

