/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.applications._DeleteApplicationRequest;

public final class DeleteApplicationRequest
extends _DeleteApplicationRequest {
    private final String applicationId;

    private DeleteApplicationRequest(Builder builder) {
        this.applicationId = builder.applicationId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteApplicationRequest && this.equalTo((DeleteApplicationRequest)another);
    }

    private boolean equalTo(DeleteApplicationRequest another) {
        return this.applicationId.equals(another.applicationId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteApplicationRequest{applicationId=" + this.applicationId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String applicationId;

        private Builder() {
        }

        public final Builder from(DeleteApplicationRequest instance) {
            return this.from((_DeleteApplicationRequest)instance);
        }

        final Builder from(_DeleteApplicationRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public DeleteApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build DeleteApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

