/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.applications._ScaleApplicationResponse;
import org.cloudfoundry.client.v3.processes.HealthCheck;
import org.cloudfoundry.client.v3.processes.Process;

public final class ScaleApplicationResponse
extends _ScaleApplicationResponse {
    @Nullable
    private final String command;
    @Nullable
    private final String createdAt;
    @Nullable
    private final Integer diskInMb;
    @Nullable
    private final HealthCheck healthCheck;
    @Nullable
    private final String id;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Map<String, Link> links;
    @Nullable
    private final Integer memoryInMb;
    @Nullable
    private final List<Integer> ports;
    @Nullable
    private final String type;
    @Nullable
    private final String updatedAt;

    private ScaleApplicationResponse(Builder builder) {
        this.command = builder.command;
        this.createdAt = builder.createdAt;
        this.diskInMb = builder.diskInMb;
        this.healthCheck = builder.healthCheck;
        this.id = builder.id;
        this.instances = builder.instances;
        this.links = builder.links == null ? null : ScaleApplicationResponse.createUnmodifiableMap(false, false, builder.links);
        this.memoryInMb = builder.memoryInMb;
        this.ports = builder.ports == null ? null : ScaleApplicationResponse.createUnmodifiableList(true, builder.ports);
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    @Override
    @JsonProperty(value="command")
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty(value="created_at")
    @Nullable
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="disk_in_mb")
    @Nullable
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    @Override
    @JsonProperty(value="health_check")
    @Nullable
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="instances")
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @JsonProperty(value="links")
    @Nullable
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="memory_in_mb")
    @Nullable
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    @JsonProperty(value="ports")
    @Nullable
    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScaleApplicationResponse && this.equalTo((ScaleApplicationResponse)another);
    }

    private boolean equalTo(ScaleApplicationResponse another) {
        return Objects.equals(this.command, another.command) && Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.diskInMb, another.diskInMb) && Objects.equals(this.healthCheck, another.healthCheck) && Objects.equals(this.id, another.id) && Objects.equals(this.instances, another.instances) && Objects.equals(this.links, another.links) && Objects.equals(this.memoryInMb, another.memoryInMb) && Objects.equals(this.ports, another.ports) && Objects.equals(this.type, another.type) && Objects.equals(this.updatedAt, another.updatedAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.command);
        h = h * 17 + Objects.hashCode(this.createdAt);
        h = h * 17 + Objects.hashCode(this.diskInMb);
        h = h * 17 + Objects.hashCode(this.healthCheck);
        h = h * 17 + Objects.hashCode(this.id);
        h = h * 17 + Objects.hashCode(this.instances);
        h = h * 17 + Objects.hashCode(this.links);
        h = h * 17 + Objects.hashCode(this.memoryInMb);
        h = h * 17 + Objects.hashCode(this.ports);
        h = h * 17 + Objects.hashCode(this.type);
        h = h * 17 + Objects.hashCode(this.updatedAt);
        return h;
    }

    public String toString() {
        return "ScaleApplicationResponse{command=" + this.command + ", createdAt=" + this.createdAt + ", diskInMb=" + this.diskInMb + ", healthCheck=" + this.healthCheck + ", id=" + this.id + ", instances=" + this.instances + ", links=" + this.links + ", memoryInMb=" + this.memoryInMb + ", ports=" + this.ports + ", type=" + this.type + ", updatedAt=" + this.updatedAt + "}";
    }

    @Deprecated
    @JsonCreator
    static ScaleApplicationResponse fromJson(Json json) {
        Builder builder = ScaleApplicationResponse.builder();
        if (json.command != null) {
            builder.command(json.command);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.diskInMb != null) {
            builder.diskInMb(json.diskInMb);
        }
        if (json.healthCheck != null) {
            builder.healthCheck(json.healthCheck);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.instances != null) {
            builder.instances(json.instances);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.memoryInMb != null) {
            builder.memoryInMb(json.memoryInMb);
        }
        if (json.ports != null) {
            builder.addAllPorts(json.ports);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private String command;
        private String createdAt;
        private Integer diskInMb;
        private HealthCheck healthCheck;
        private String id;
        private Integer instances;
        private Map<String, Link> links = null;
        private Integer memoryInMb;
        private List<Integer> ports = null;
        private String type;
        private String updatedAt;

        private Builder() {
        }

        public final Builder from(Process instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ScaleApplicationResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ScaleApplicationResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Process) {
                String updatedAtValue;
                String commandValue;
                String typeValue;
                List<Integer> portsValue;
                String idValue;
                Map<String, Link> linksValue;
                HealthCheck healthCheckValue;
                Integer memoryInMbValue;
                Integer instancesValue;
                String createdAtValue;
                Process instance = (Process)object;
                Integer diskInMbValue = instance.getDiskInMb();
                if (diskInMbValue != null) {
                    this.diskInMb(diskInMbValue);
                }
                if ((createdAtValue = instance.getCreatedAt()) != null) {
                    this.createdAt(createdAtValue);
                }
                if ((instancesValue = instance.getInstances()) != null) {
                    this.instances(instancesValue);
                }
                if ((memoryInMbValue = instance.getMemoryInMb()) != null) {
                    this.memoryInMb(memoryInMbValue);
                }
                if ((healthCheckValue = instance.getHealthCheck()) != null) {
                    this.healthCheck(healthCheckValue);
                }
                if ((linksValue = instance.getLinks()) != null) {
                    this.putAllLinks(linksValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
                if ((portsValue = instance.getPorts()) != null) {
                    this.addAllPorts(portsValue);
                }
                if ((typeValue = instance.getType()) != null) {
                    this.type(typeValue);
                }
                if ((commandValue = instance.getCommand()) != null) {
                    this.command(commandValue);
                }
                if ((updatedAtValue = instance.getUpdatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        public final Builder createdAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Builder diskInMb(@Nullable Integer diskInMb) {
            this.diskInMb = diskInMb;
            return this;
        }

        public final Builder healthCheck(@Nullable HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Builder link(String key, Link value) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            this.links.put(Objects.requireNonNull(key, "links key"), Objects.requireNonNull(value, "links value"));
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(Objects.requireNonNull(k, "links key"), Objects.requireNonNull(v, "links value"));
            return this;
        }

        public final Builder links(@Nullable Map<String, ? extends Link> links) {
            if (links == null) {
                this.links = null;
                return this;
            }
            this.links = new LinkedHashMap<String, Link>();
            return this.putAllLinks(links);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> links) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
                String k = entry.getKey();
                Link v = entry.getValue();
                this.links.put(Objects.requireNonNull(k, "links key"), Objects.requireNonNull(v, "links value"));
            }
            return this;
        }

        public final Builder memoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public final Builder port(int element) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            this.ports.add(element);
            return this;
        }

        public final Builder port(int ... elements) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(element);
            }
            return this;
        }

        public final Builder ports(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.ports = null;
                return this;
            }
            this.ports = new ArrayList<Integer>();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "ports element");
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(Objects.requireNonNull(Integer.valueOf(element), "ports element"));
            }
            return this;
        }

        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ScaleApplicationResponse build() {
            return new ScaleApplicationResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ScaleApplicationResponse {
        String command;
        String createdAt;
        Integer diskInMb;
        HealthCheck healthCheck;
        String id;
        Integer instances;
        Map<String, Link> links;
        Integer memoryInMb;
        List<Integer> ports = null;
        String type;
        String updatedAt;

        Json() {
        }

        @JsonProperty(value="command")
        public void setCommand(@Nullable String command) {
            this.command = command;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="disk_in_mb")
        public void setDiskInMb(@Nullable Integer diskInMb) {
            this.diskInMb = diskInMb;
        }

        @JsonProperty(value="health_check")
        public void setHealthCheck(@Nullable HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        @JsonProperty(value="guid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="instances")
        public void setInstances(@Nullable Integer instances) {
            this.instances = instances;
        }

        @JsonProperty(value="links")
        public void setLinks(@Nullable Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="memory_in_mb")
        public void setMemoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
        }

        @JsonProperty(value="ports")
        public void setPorts(@Nullable List<Integer> ports) {
            this.ports = ports;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getDiskInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HealthCheck getHealthCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemoryInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> getPorts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

