/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.applications.Application;
import org.cloudfoundry.client.v3.applications._UpdateApplicationResponse;

public final class UpdateApplicationResponse
extends _UpdateApplicationResponse {
    @Nullable
    private final String createdAt;
    @Nullable
    private final String desiredState;
    @Nullable
    private final Map<String, String> environmentVariables;
    @Nullable
    private final String id;
    @Nullable
    private final Lifecycle lifecycle;
    @Nullable
    private final Map<String, Link> links;
    @Nullable
    private final String name;
    @Nullable
    private final Integer totalDesiredInstances;
    @Nullable
    private final String updatedAt;

    private UpdateApplicationResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.desiredState = builder.desiredState;
        this.environmentVariables = builder.environmentVariables == null ? null : UpdateApplicationResponse.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.id = builder.id;
        this.lifecycle = builder.lifecycle;
        this.links = builder.links == null ? null : UpdateApplicationResponse.createUnmodifiableMap(false, false, builder.links);
        this.name = builder.name;
        this.totalDesiredInstances = builder.totalDesiredInstances;
        this.updatedAt = builder.updatedAt;
    }

    @Override
    @JsonProperty(value="created_at")
    @Nullable
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="desired_state")
    @Nullable
    public String getDesiredState() {
        return this.desiredState;
    }

    @Override
    @JsonProperty(value="environment_variables")
    @Nullable
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="lifecycle")
    @Nullable
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @JsonProperty(value="links")
    @Nullable
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="total_desired_instances")
    @Nullable
    public Integer getTotalDesiredInstances() {
        return this.totalDesiredInstances;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateApplicationResponse && this.equalTo((UpdateApplicationResponse)another);
    }

    private boolean equalTo(UpdateApplicationResponse another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.desiredState, another.desiredState) && Objects.equals(this.environmentVariables, another.environmentVariables) && Objects.equals(this.id, another.id) && Objects.equals(this.lifecycle, another.lifecycle) && Objects.equals(this.links, another.links) && Objects.equals(this.name, another.name) && Objects.equals(this.totalDesiredInstances, another.totalDesiredInstances) && Objects.equals(this.updatedAt, another.updatedAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.createdAt);
        h = h * 17 + Objects.hashCode(this.desiredState);
        h = h * 17 + Objects.hashCode(this.environmentVariables);
        h = h * 17 + Objects.hashCode(this.id);
        h = h * 17 + Objects.hashCode(this.lifecycle);
        h = h * 17 + Objects.hashCode(this.links);
        h = h * 17 + Objects.hashCode(this.name);
        h = h * 17 + Objects.hashCode(this.totalDesiredInstances);
        h = h * 17 + Objects.hashCode(this.updatedAt);
        return h;
    }

    public String toString() {
        return "UpdateApplicationResponse{createdAt=" + this.createdAt + ", desiredState=" + this.desiredState + ", environmentVariables=" + this.environmentVariables + ", id=" + this.id + ", lifecycle=" + this.lifecycle + ", links=" + this.links + ", name=" + this.name + ", totalDesiredInstances=" + this.totalDesiredInstances + ", updatedAt=" + this.updatedAt + "}";
    }

    @Deprecated
    @JsonCreator
    static UpdateApplicationResponse fromJson(Json json) {
        Builder builder = UpdateApplicationResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.desiredState != null) {
            builder.desiredState(json.desiredState);
        }
        if (json.environmentVariables != null) {
            builder.putAllEnvironmentVariables(json.environmentVariables);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.lifecycle != null) {
            builder.lifecycle(json.lifecycle);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.totalDesiredInstances != null) {
            builder.totalDesiredInstances(json.totalDesiredInstances);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private String createdAt;
        private String desiredState;
        private Map<String, String> environmentVariables = null;
        private String id;
        private Lifecycle lifecycle;
        private Map<String, Link> links = null;
        private String name;
        private Integer totalDesiredInstances;
        private String updatedAt;

        private Builder() {
        }

        public final Builder from(Application instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateApplicationResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_UpdateApplicationResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Application) {
                String updatedAtValue;
                Integer totalDesiredInstancesValue;
                String idValue;
                Map<String, Link> linksValue;
                String nameValue;
                Map<String, String> environmentVariablesValue;
                String desiredStateValue;
                String createdAtValue;
                Application instance = (Application)object;
                Lifecycle lifecycleValue = instance.getLifecycle();
                if (lifecycleValue != null) {
                    this.lifecycle(lifecycleValue);
                }
                if ((createdAtValue = instance.getCreatedAt()) != null) {
                    this.createdAt(createdAtValue);
                }
                if ((desiredStateValue = instance.getDesiredState()) != null) {
                    this.desiredState(desiredStateValue);
                }
                if ((environmentVariablesValue = instance.getEnvironmentVariables()) != null) {
                    this.putAllEnvironmentVariables(environmentVariablesValue);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((linksValue = instance.getLinks()) != null) {
                    this.putAllLinks(linksValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
                if ((totalDesiredInstancesValue = instance.getTotalDesiredInstances()) != null) {
                    this.totalDesiredInstances(totalDesiredInstancesValue);
                }
                if ((updatedAtValue = instance.getUpdatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        public final Builder createdAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Builder desiredState(@Nullable String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        public final Builder environmentVariable(String key, String value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            this.environmentVariables.put(Objects.requireNonNull(key, "environmentVariables key"), Objects.requireNonNull(value, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends String> environmentVariables) {
            if (environmentVariables == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, String>();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends String> environmentVariables) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            }
            return this;
        }

        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final Builder link(String key, Link value) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            this.links.put(Objects.requireNonNull(key, "links key"), Objects.requireNonNull(value, "links value"));
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(Objects.requireNonNull(k, "links key"), Objects.requireNonNull(v, "links value"));
            return this;
        }

        public final Builder links(@Nullable Map<String, ? extends Link> links) {
            if (links == null) {
                this.links = null;
                return this;
            }
            this.links = new LinkedHashMap<String, Link>();
            return this.putAllLinks(links);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> links) {
            if (this.links == null) {
                this.links = new LinkedHashMap<String, Link>();
            }
            for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
                String k = entry.getKey();
                Link v = entry.getValue();
                this.links.put(Objects.requireNonNull(k, "links key"), Objects.requireNonNull(v, "links value"));
            }
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder totalDesiredInstances(@Nullable Integer totalDesiredInstances) {
            this.totalDesiredInstances = totalDesiredInstances;
            return this;
        }

        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public UpdateApplicationResponse build() {
            return new UpdateApplicationResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _UpdateApplicationResponse {
        String createdAt;
        String desiredState;
        Map<String, String> environmentVariables;
        String id;
        Lifecycle lifecycle;
        Map<String, Link> links;
        String name;
        Integer totalDesiredInstances;
        String updatedAt;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="desired_state")
        public void setDesiredState(@Nullable String desiredState) {
            this.desiredState = desiredState;
        }

        @JsonProperty(value="environment_variables")
        public void setEnvironmentVariables(@Nullable Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        @JsonProperty(value="guid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="lifecycle")
        public void setLifecycle(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        @JsonProperty(value="links")
        public void setLinks(@Nullable Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="total_desired_instances")
        public void setTotalDesiredInstances(@Nullable Integer totalDesiredInstances) {
            this.totalDesiredInstances = totalDesiredInstances;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDesiredState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getEnvironmentVariables() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Lifecycle getLifecycle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getTotalDesiredInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

