/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.packages._CopyPackageRequest;

public final class CopyPackageRequest
extends _CopyPackageRequest {
    private final String applicationId;
    private final String sourcePackageId;

    private CopyPackageRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.sourcePackageId = builder.sourcePackageId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getSourcePackageId() {
        return this.sourcePackageId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CopyPackageRequest && this.equalTo((CopyPackageRequest)another);
    }

    private boolean equalTo(CopyPackageRequest another) {
        return this.applicationId.equals(another.applicationId) && this.sourcePackageId.equals(another.sourcePackageId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + this.sourcePackageId.hashCode();
        return h;
    }

    public String toString() {
        return "CopyPackageRequest{applicationId=" + this.applicationId + ", sourcePackageId=" + this.sourcePackageId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_SOURCE_PACKAGE_ID = 2L;
        private long initBits = 3L;
        private String applicationId;
        private String sourcePackageId;

        private Builder() {
        }

        public final Builder from(CopyPackageRequest instance) {
            return this.from((_CopyPackageRequest)instance);
        }

        final Builder from(_CopyPackageRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.sourcePackageId(instance.getSourcePackageId());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sourcePackageId(String sourcePackageId) {
            this.sourcePackageId = Objects.requireNonNull(sourcePackageId, "sourcePackageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CopyPackageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CopyPackageRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sourcePackageId");
            }
            return "Cannot build CopyPackageRequest, some of required attributes are not set " + attributes;
        }
    }
}

