/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Data;
import org.cloudfoundry.client.v3.packages.PackageType;
import org.cloudfoundry.client.v3.packages._CreatePackageRequest;

public final class CreatePackageRequest
extends _CreatePackageRequest {
    private final String applicationId;
    @Nullable
    private final Data data;
    private final PackageType type;

    private CreatePackageRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.data = builder.data;
        this.type = builder.type;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nullable
    public Data getData() {
        return this.data;
    }

    @Override
    public PackageType getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreatePackageRequest && this.equalTo((CreatePackageRequest)another);
    }

    private boolean equalTo(CreatePackageRequest another) {
        return this.applicationId.equals(another.applicationId) && Objects.equals(this.data, another.data) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + Objects.hashCode(this.data);
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "CreatePackageRequest{applicationId=" + this.applicationId + ", data=" + this.data + ", type=" + (Object)((Object)this.type) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private String applicationId;
        private Data data;
        private PackageType type;

        private Builder() {
        }

        public final Builder from(CreatePackageRequest instance) {
            return this.from((_CreatePackageRequest)instance);
        }

        final Builder from(_CreatePackageRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            Data dataValue = instance.getData();
            if (dataValue != null) {
                this.data(dataValue);
            }
            this.type(instance.getType());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder data(@Nullable Data data) {
            this.data = data;
            return this;
        }

        public final Builder type(PackageType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreatePackageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreatePackageRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build CreatePackageRequest, some of required attributes are not set " + attributes;
        }
    }
}

