/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.packages._GetPackageRequest;

public final class GetPackageRequest
extends _GetPackageRequest {
    private final String packageId;

    private GetPackageRequest(Builder builder) {
        this.packageId = builder.packageId;
    }

    @Override
    public String getPackageId() {
        return this.packageId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetPackageRequest && this.equalTo((GetPackageRequest)another);
    }

    private boolean equalTo(GetPackageRequest another) {
        return this.packageId.equals(another.packageId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.packageId.hashCode();
        return h;
    }

    public String toString() {
        return "GetPackageRequest{packageId=" + this.packageId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PACKAGE_ID = 1L;
        private long initBits = 1L;
        private String packageId;

        private Builder() {
        }

        public final Builder from(GetPackageRequest instance) {
            return this.from((_GetPackageRequest)instance);
        }

        final Builder from(_GetPackageRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.packageId(instance.getPackageId());
            return this;
        }

        public final Builder packageId(String packageId) {
            this.packageId = Objects.requireNonNull(packageId, "packageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public GetPackageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetPackageRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("packageId");
            }
            return "Cannot build GetPackageRequest, some of required attributes are not set " + attributes;
        }
    }
}

