/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.packages.BitsData;
import org.cloudfoundry.client.v3.packages.Data;
import org.cloudfoundry.client.v3.packages.DockerData;
import org.cloudfoundry.client.v3.packages.PackageType;
import org.cloudfoundry.client.v3.packages.State;
import reactor.core.Exceptions;

public abstract class Package {
    @JsonProperty(value="created_at")
    @Nullable
    public abstract String getCreatedAt();

    @JsonDeserialize(using=DataDeserializer.class)
    @JsonProperty(value="data")
    @Nullable
    public abstract Data getData();

    @JsonProperty(value="guid")
    @Nullable
    public abstract String getId();

    @JsonProperty(value="links")
    @Nullable
    public abstract Map<String, Link> getLinks();

    @JsonProperty(value="state")
    @Nullable
    public abstract State getState();

    @JsonProperty(value="type")
    @Nullable
    public abstract PackageType getType();

    @JsonProperty(value="updated_at")
    @Nullable
    public abstract String getUpdatedAt();

    public static final class DataDeserializer
    extends StdDeserializer<Data> {
        private static final long serialVersionUID = 8880263435485035323L;

        DataDeserializer() {
            super(Data.class);
        }

        public Data deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            PackageType packageType = this.getPackageType(p.getParsingContext().getParent().getCurrentValue());
            switch (packageType) {
                case BITS: {
                    return (Data)p.readValueAs(BitsData.class);
                }
                case DOCKER: {
                    return (Data)p.readValueAs(DockerData.class);
                }
            }
            throw new IllegalArgumentException(String.format("Unknown package type: %s", new Object[]{packageType}));
        }

        private PackageType getPackageType(Object packag) {
            try {
                return (PackageType)((Object)packag.getClass().getDeclaredField("type").get(packag));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
    }
}

