/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum State {
    AWAITING_UPLOAD("AWAITING_UPLOAD"),
    COPYING("COPYING"),
    EXPIRED("EXPIRED"),
    FAILED("FAILED"),
    PROCESSING_UPLOAD("PROCESSING_UPLOAD"),
    READY("READY");

    private final String value;

    private State(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    static State from(String s) {
        switch (s.toLowerCase()) {
            case "awaiting_upload": {
                return AWAITING_UPLOAD;
            }
            case "copying": {
                return COPYING;
            }
            case "expired": {
                return EXPIRED;
            }
            case "failed": {
                return FAILED;
            }
            case "processing_upload": {
                return PROCESSING_UPLOAD;
            }
            case "ready": {
                return READY;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown state: %s", s));
    }
}

