/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.processes._GetProcessRequest;

public final class GetProcessRequest
extends _GetProcessRequest {
    private final String processId;

    private GetProcessRequest(Builder builder) {
        this.processId = builder.processId;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetProcessRequest && this.equalTo((GetProcessRequest)another);
    }

    private boolean equalTo(GetProcessRequest another) {
        return this.processId.equals(another.processId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.processId.hashCode();
        return h;
    }

    public String toString() {
        return "GetProcessRequest{processId=" + this.processId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PROCESS_ID = 1L;
        private long initBits = 1L;
        private String processId;

        private Builder() {
        }

        public final Builder from(GetProcessRequest instance) {
            return this.from((_GetProcessRequest)instance);
        }

        final Builder from(_GetProcessRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.processId(instance.getProcessId());
            return this;
        }

        public final Builder processId(String processId) {
            this.processId = Objects.requireNonNull(processId, "processId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public GetProcessRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetProcessRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("processId");
            }
            return "Cannot build GetProcessRequest, some of required attributes are not set " + attributes;
        }
    }
}

