/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.servicebindings._Relationships;

public final class Relationships
extends _Relationships {
    private final Relationship application;
    private final Relationship serviceInstance;

    private Relationships(Builder builder) {
        this.application = builder.application;
        this.serviceInstance = builder.serviceInstance;
    }

    @Override
    public Relationship getApplication() {
        return this.application;
    }

    @Override
    public Relationship getServiceInstance() {
        return this.serviceInstance;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Relationships && this.equalTo((Relationships)another);
    }

    private boolean equalTo(Relationships another) {
        return this.application.equals(another.application) && this.serviceInstance.equals(another.serviceInstance);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.application.hashCode();
        h = h * 17 + this.serviceInstance.hashCode();
        return h;
    }

    public String toString() {
        return "Relationships{application=" + this.application + ", serviceInstance=" + this.serviceInstance + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION = 1L;
        private static final long INIT_BIT_SERVICE_INSTANCE = 2L;
        private long initBits = 3L;
        private Relationship application;
        private Relationship serviceInstance;

        private Builder() {
        }

        public final Builder from(Relationships instance) {
            return this.from((_Relationships)instance);
        }

        final Builder from(_Relationships instance) {
            Objects.requireNonNull(instance, "instance");
            this.application(instance.getApplication());
            this.serviceInstance(instance.getServiceInstance());
            return this;
        }

        public final Builder application(Relationship application) {
            this.application = Objects.requireNonNull(application, "application");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder serviceInstance(Relationship serviceInstance) {
            this.serviceInstance = Objects.requireNonNull(serviceInstance, "serviceInstance");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Relationships build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Relationships(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("application");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceInstance");
            }
            return "Cannot build Relationships, some of required attributes are not set " + attributes;
        }
    }
}

