/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.tasks._CreateTaskRequest;

public final class CreateTaskRequest
extends _CreateTaskRequest {
    private final String applicationId;
    private final String command;
    @Nullable
    private final String dropletId;
    @Nullable
    private final Map<String, String> environmentVariables;
    @Nullable
    private final Integer memoryInMb;
    private final String name;

    private CreateTaskRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.command = builder.command;
        this.dropletId = builder.dropletId;
        this.environmentVariables = builder.environmentVariables == null ? null : CreateTaskRequest.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.memoryInMb = builder.memoryInMb;
        this.name = builder.name;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    public String getDropletId() {
        return this.dropletId;
    }

    @Override
    @Nullable
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @Nullable
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateTaskRequest && this.equalTo((CreateTaskRequest)another);
    }

    private boolean equalTo(CreateTaskRequest another) {
        return this.applicationId.equals(another.applicationId) && this.command.equals(another.command) && Objects.equals(this.dropletId, another.dropletId) && Objects.equals(this.environmentVariables, another.environmentVariables) && Objects.equals(this.memoryInMb, another.memoryInMb) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationId.hashCode();
        h = h * 17 + this.command.hashCode();
        h = h * 17 + Objects.hashCode(this.dropletId);
        h = h * 17 + Objects.hashCode(this.environmentVariables);
        h = h * 17 + Objects.hashCode(this.memoryInMb);
        h = h * 17 + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "CreateTaskRequest{applicationId=" + this.applicationId + ", command=" + this.command + ", dropletId=" + this.dropletId + ", environmentVariables=" + this.environmentVariables + ", memoryInMb=" + this.memoryInMb + ", name=" + this.name + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_COMMAND = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private long initBits = 7L;
        private String applicationId;
        private String command;
        private String dropletId;
        private Map<String, String> environmentVariables = null;
        private Integer memoryInMb;
        private String name;

        private Builder() {
        }

        public final Builder from(CreateTaskRequest instance) {
            return this.from((_CreateTaskRequest)instance);
        }

        final Builder from(_CreateTaskRequest instance) {
            Integer memoryInMbValue;
            Map<String, String> environmentVariablesValue;
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.command(instance.getCommand());
            String dropletIdValue = instance.getDropletId();
            if (dropletIdValue != null) {
                this.dropletId(dropletIdValue);
            }
            if ((environmentVariablesValue = instance.getEnvironmentVariables()) != null) {
                this.putAllEnvironmentVariables(environmentVariablesValue);
            }
            if ((memoryInMbValue = instance.getMemoryInMb()) != null) {
                this.memoryInMb(memoryInMbValue);
            }
            this.name(instance.getName());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder dropletId(@Nullable String dropletId) {
            this.dropletId = dropletId;
            return this;
        }

        public final Builder environmentVariable(String key, String value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            this.environmentVariables.put(Objects.requireNonNull(key, "environmentVariables key"), Objects.requireNonNull(value, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends String> environmentVariables) {
            if (environmentVariables == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, String>();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends String> environmentVariables) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            }
            return this;
        }

        public final Builder memoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public CreateTaskRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateTaskRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("command");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateTaskRequest, some of required attributes are not set " + attributes;
        }
    }
}

