/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.doppler;

import java.util.Objects;
import org.cloudfoundry.dropsonde.events.Envelope;

public enum EventType {
    CONTAINER_METRIC,
    COUNTER_EVENT,
    ERROR,
    HTTP_START,
    HTTP_START_STOP,
    HTTP_STOP,
    LOG_MESSAGE,
    VALUE_METRIC;


    static EventType from(Envelope.EventType dropsonde) {
        switch (Objects.requireNonNull(dropsonde, "dropsonde")) {
            case ContainerMetric: {
                return CONTAINER_METRIC;
            }
            case CounterEvent: {
                return COUNTER_EVENT;
            }
            case Error: {
                return ERROR;
            }
            case HttpStart: {
                return HTTP_START;
            }
            case HttpStartStop: {
                return HTTP_START_STOP;
            }
            case HttpStop: {
                return HTTP_STOP;
            }
            case LogMessage: {
                return LOG_MESSAGE;
            }
            case ValueMetric: {
                return VALUE_METRIC;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown event type: %s", new Object[]{dropsonde}));
    }
}

