/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.doppler.PeerType;
import org.cloudfoundry.doppler._HttpStop;

public final class HttpStop
extends _HttpStop {
    @Nullable
    private final UUID applicationId;
    private final Long contentLength;
    private final PeerType peerType;
    private final UUID requestId;
    private final Integer statusCode;
    private final Long timestamp;
    private final String uri;

    private HttpStop(Builder builder) {
        this.applicationId = builder.applicationId;
        this.contentLength = builder.contentLength;
        this.peerType = builder.peerType;
        this.requestId = builder.requestId;
        this.statusCode = builder.statusCode;
        this.timestamp = builder.timestamp;
        this.uri = builder.uri;
    }

    @Override
    @Nullable
    public UUID getApplicationId() {
        return this.applicationId;
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public PeerType getPeerType() {
        return this.peerType;
    }

    @Override
    public UUID getRequestId() {
        return this.requestId;
    }

    @Override
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HttpStop && this.equalTo((HttpStop)another);
    }

    private boolean equalTo(HttpStop another) {
        return Objects.equals(this.applicationId, another.applicationId) && this.contentLength.equals(another.contentLength) && this.peerType.equals((Object)another.peerType) && this.requestId.equals(another.requestId) && this.statusCode.equals(another.statusCode) && this.timestamp.equals(another.timestamp) && this.uri.equals(another.uri);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.applicationId);
        h = h * 17 + this.contentLength.hashCode();
        h = h * 17 + this.peerType.hashCode();
        h = h * 17 + this.requestId.hashCode();
        h = h * 17 + this.statusCode.hashCode();
        h = h * 17 + this.timestamp.hashCode();
        h = h * 17 + this.uri.hashCode();
        return h;
    }

    public String toString() {
        return "HttpStop{applicationId=" + this.applicationId + ", contentLength=" + this.contentLength + ", peerType=" + (Object)((Object)this.peerType) + ", requestId=" + this.requestId + ", statusCode=" + this.statusCode + ", timestamp=" + this.timestamp + ", uri=" + this.uri + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CONTENT_LENGTH = 1L;
        private static final long INIT_BIT_PEER_TYPE = 2L;
        private static final long INIT_BIT_REQUEST_ID = 4L;
        private static final long INIT_BIT_STATUS_CODE = 8L;
        private static final long INIT_BIT_TIMESTAMP = 16L;
        private static final long INIT_BIT_URI = 32L;
        private long initBits = 63L;
        private UUID applicationId;
        private Long contentLength;
        private PeerType peerType;
        private UUID requestId;
        private Integer statusCode;
        private Long timestamp;
        private String uri;

        private Builder() {
        }

        public final Builder from(HttpStop instance) {
            return this.from((_HttpStop)instance);
        }

        final Builder from(_HttpStop instance) {
            Objects.requireNonNull(instance, "instance");
            UUID applicationIdValue = instance.getApplicationId();
            if (applicationIdValue != null) {
                this.applicationId(applicationIdValue);
            }
            this.contentLength(instance.getContentLength());
            this.peerType(instance.getPeerType());
            this.requestId(instance.getRequestId());
            this.statusCode(instance.getStatusCode());
            this.timestamp(instance.getTimestamp());
            this.uri(instance.getUri());
            return this;
        }

        public final Builder applicationId(@Nullable UUID applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Builder contentLength(Long contentLength) {
            this.contentLength = Objects.requireNonNull(contentLength, "contentLength");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder peerType(PeerType peerType) {
            this.peerType = Objects.requireNonNull(peerType, "peerType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder requestId(UUID requestId) {
            this.requestId = Objects.requireNonNull(requestId, "requestId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder statusCode(Integer statusCode) {
            this.statusCode = Objects.requireNonNull(statusCode, "statusCode");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder timestamp(Long timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public HttpStop build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new HttpStop(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentLength");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peerType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("requestId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("statusCode");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("timestamp");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("uri");
            }
            return "Cannot build HttpStop, some of required attributes are not set " + attributes;
        }
    }
}

