/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest;

public final class BatchDeleteClientsRequest
extends _BatchDeleteClientsRequest {
    @Nullable
    private final List<String> clientIds;
    @Nullable
    private final String identityZoneId;

    private BatchDeleteClientsRequest(Builder builder) {
        this.clientIds = builder.clientIds == null ? null : BatchDeleteClientsRequest.createUnmodifiableList(true, builder.clientIds);
        this.identityZoneId = builder.identityZoneId;
    }

    @Override
    @JsonProperty(value="clientIds")
    @JsonIgnore
    @Nullable
    public List<String> getClientIds() {
        return this.clientIds;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BatchDeleteClientsRequest && this.equalTo((BatchDeleteClientsRequest)another);
    }

    private boolean equalTo(BatchDeleteClientsRequest another) {
        return Objects.equals(this.clientIds, another.clientIds) && Objects.equals(this.identityZoneId, another.identityZoneId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.clientIds);
        h = h * 17 + Objects.hashCode(this.identityZoneId);
        return h;
    }

    public String toString() {
        return "BatchDeleteClientsRequest{clientIds=" + this.clientIds + ", identityZoneId=" + this.identityZoneId + "}";
    }

    @Deprecated
    @JsonCreator
    static BatchDeleteClientsRequest fromJson(Json json) {
        Builder builder = BatchDeleteClientsRequest.builder();
        if (json.clientIds != null) {
            builder.addAllClientIds(json.clientIds);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        return builder.build();
    }

    private static BatchDeleteClientsRequest validate(BatchDeleteClientsRequest instance) {
        instance.checkClientIds();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> clientIds = null;
        private String identityZoneId;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BatchDeleteClientsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_BatchDeleteClientsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            List<String> clientIdsValue;
            IdentityZoned instance;
            String identityZoneIdValue;
            if (object instanceof IdentityZoned && (identityZoneIdValue = (instance = (IdentityZoned)object).getIdentityZoneId()) != null) {
                this.identityZoneId(identityZoneIdValue);
            }
            if (object instanceof _BatchDeleteClientsRequest && (clientIdsValue = ((_BatchDeleteClientsRequest)(instance = (_BatchDeleteClientsRequest)object)).getClientIds()) != null) {
                this.addAllClientIds(clientIdsValue);
            }
        }

        public final Builder clientId(String element) {
            if (this.clientIds == null) {
                this.clientIds = new ArrayList<String>();
            }
            this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
            return this;
        }

        public final Builder clientId(String ... elements) {
            if (this.clientIds == null) {
                this.clientIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
            }
            return this;
        }

        public final Builder clientIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.clientIds = null;
                return this;
            }
            this.clientIds = new ArrayList<String>();
            return this.addAllClientIds(elements);
        }

        public final Builder addAllClientIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "clientIds element");
            if (this.clientIds == null) {
                this.clientIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
            }
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public BatchDeleteClientsRequest build() {
            return BatchDeleteClientsRequest.validate(new BatchDeleteClientsRequest(this));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _BatchDeleteClientsRequest {
        List<String> clientIds = null;
        String identityZoneId;

        Json() {
        }

        @JsonProperty(value="clientIds")
        @JsonIgnore
        public void setClientIds(@Nullable List<String> clientIds) {
            this.clientIds = clientIds;
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @Override
        public List<String> getClientIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }
    }
}

