/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.PaginatedAndSortedByRequest;
import org.cloudfoundry.uaa.PaginatedAndSortedRequest;
import org.cloudfoundry.uaa.SortOrder;
import org.cloudfoundry.uaa.groups._ListGroupsRequest;

public final class ListGroupsRequest
extends _ListGroupsRequest {
    @Nullable
    private final String sortBy;
    @Nullable
    private final Integer count;
    @Nullable
    private final String filter;
    @Nullable
    private final SortOrder sortOrder;
    @Nullable
    private final Integer startIndex;
    @Nullable
    private final String identityZoneId;

    private ListGroupsRequest(Builder builder) {
        this.sortBy = builder.sortBy;
        this.count = builder.count;
        this.filter = builder.filter;
        this.sortOrder = builder.sortOrder;
        this.startIndex = builder.startIndex;
        this.identityZoneId = builder.identityZoneId;
    }

    @Override
    @Nullable
    public String getSortBy() {
        return this.sortBy;
    }

    @Override
    @Nullable
    public Integer getCount() {
        return this.count;
    }

    @Override
    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Override
    @Nullable
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    @Nullable
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListGroupsRequest && this.equalTo((ListGroupsRequest)another);
    }

    private boolean equalTo(ListGroupsRequest another) {
        return Objects.equals(this.sortBy, another.sortBy) && Objects.equals(this.count, another.count) && Objects.equals(this.filter, another.filter) && Objects.equals((Object)this.sortOrder, (Object)another.sortOrder) && Objects.equals(this.startIndex, another.startIndex) && Objects.equals(this.identityZoneId, another.identityZoneId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.sortBy);
        h = h * 17 + Objects.hashCode(this.count);
        h = h * 17 + Objects.hashCode(this.filter);
        h = h * 17 + Objects.hashCode((Object)this.sortOrder);
        h = h * 17 + Objects.hashCode(this.startIndex);
        h = h * 17 + Objects.hashCode(this.identityZoneId);
        return h;
    }

    public String toString() {
        return "ListGroupsRequest{sortBy=" + this.sortBy + ", count=" + this.count + ", filter=" + this.filter + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", startIndex=" + this.startIndex + ", identityZoneId=" + this.identityZoneId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String sortBy;
        private Integer count;
        private String filter;
        private SortOrder sortOrder;
        private Integer startIndex;
        private String identityZoneId;

        private Builder() {
        }

        public final Builder from(PaginatedAndSortedByRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedAndSortedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListGroupsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListGroupsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String identityZoneIdValue;
            Object instance;
            String sortByValue;
            if (object instanceof PaginatedAndSortedByRequest && (sortByValue = ((PaginatedAndSortedByRequest)(instance = (PaginatedAndSortedByRequest)object)).getSortBy()) != null) {
                this.sortBy(sortByValue);
            }
            if (object instanceof IdentityZoned && (identityZoneIdValue = (instance = (IdentityZoned)object).getIdentityZoneId()) != null) {
                this.identityZoneId(identityZoneIdValue);
            }
            if (object instanceof PaginatedAndSortedRequest) {
                SortOrder sortOrderValue;
                Integer startIndexValue;
                Integer countValue;
                instance = (PaginatedAndSortedRequest)object;
                String filterValue = ((PaginatedAndSortedRequest)instance).getFilter();
                if (filterValue != null) {
                    this.filter(filterValue);
                }
                if ((countValue = ((PaginatedAndSortedRequest)instance).getCount()) != null) {
                    this.count(countValue);
                }
                if ((startIndexValue = ((PaginatedAndSortedRequest)instance).getStartIndex()) != null) {
                    this.startIndex(startIndexValue);
                }
                if ((sortOrderValue = ((PaginatedAndSortedRequest)instance).getSortOrder()) != null) {
                    this.sortOrder(sortOrderValue);
                }
            }
        }

        public final Builder sortBy(@Nullable String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final Builder count(@Nullable Integer count) {
            this.count = count;
            return this;
        }

        public final Builder filter(@Nullable String filter) {
            this.filter = filter;
            return this;
        }

        public final Builder sortOrder(@Nullable SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public final Builder startIndex(@Nullable Integer startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public ListGroupsRequest build() {
            return new ListGroupsRequest(this);
        }
    }
}

