/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.identityproviders._DeleteIdentityProviderRequest;

public final class DeleteIdentityProviderRequest
extends _DeleteIdentityProviderRequest {
    private final String identityProviderId;
    @Nullable
    private final String identityZoneId;

    private DeleteIdentityProviderRequest(Builder builder) {
        this.identityProviderId = builder.identityProviderId;
        this.identityZoneId = builder.identityZoneId;
    }

    @Override
    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteIdentityProviderRequest && this.equalTo((DeleteIdentityProviderRequest)another);
    }

    private boolean equalTo(DeleteIdentityProviderRequest another) {
        return this.identityProviderId.equals(another.identityProviderId) && Objects.equals(this.identityZoneId, another.identityZoneId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.identityProviderId.hashCode();
        h = h * 17 + Objects.hashCode(this.identityZoneId);
        return h;
    }

    public String toString() {
        return "DeleteIdentityProviderRequest{identityProviderId=" + this.identityProviderId + ", identityZoneId=" + this.identityZoneId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_IDENTITY_PROVIDER_ID = 1L;
        private long initBits = 1L;
        private String identityProviderId;
        private String identityZoneId;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DeleteIdentityProviderRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_DeleteIdentityProviderRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            String identityZoneIdValue;
            if (object instanceof IdentityZoned && (identityZoneIdValue = (instance = (IdentityZoned)object).getIdentityZoneId()) != null) {
                this.identityZoneId(identityZoneIdValue);
            }
            if (object instanceof _DeleteIdentityProviderRequest) {
                instance = (_DeleteIdentityProviderRequest)object;
                this.identityProviderId(((_DeleteIdentityProviderRequest)instance).getIdentityProviderId());
            }
        }

        public final Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = Objects.requireNonNull(identityProviderId, "identityProviderId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public DeleteIdentityProviderRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteIdentityProviderRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identityProviderId");
            }
            return "Cannot build DeleteIdentityProviderRequest, some of required attributes are not set " + attributes;
        }
    }
}

