/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.identityproviders.IdentityProvider;
import org.cloudfoundry.uaa.identityproviders._ListIdentityProvidersResponse;

public final class ListIdentityProvidersResponse
extends _ListIdentityProvidersResponse {
    private final List<IdentityProvider> identityProviders;

    private ListIdentityProvidersResponse(Builder builder) {
        this.identityProviders = ListIdentityProvidersResponse.createUnmodifiableList(true, builder.identityProviders);
    }

    @Override
    @JsonProperty(value="identityProviders")
    public List<IdentityProvider> getIdentityProviders() {
        return this.identityProviders;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListIdentityProvidersResponse && this.equalTo((ListIdentityProvidersResponse)another);
    }

    private boolean equalTo(ListIdentityProvidersResponse another) {
        return this.identityProviders.equals(another.identityProviders);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.identityProviders.hashCode();
        return h;
    }

    public String toString() {
        return "ListIdentityProvidersResponse{identityProviders=" + this.identityProviders + "}";
    }

    @Deprecated
    @JsonCreator
    static ListIdentityProvidersResponse fromJson(Json json) {
        Builder builder = ListIdentityProvidersResponse.builder();
        if (json.identityProviders != null) {
            builder.addAllIdentityProviders(json.identityProviders);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<IdentityProvider> identityProviders = new ArrayList<IdentityProvider>();

        private Builder() {
        }

        public final Builder from(ListIdentityProvidersResponse instance) {
            return this.from((_ListIdentityProvidersResponse)instance);
        }

        final Builder from(_ListIdentityProvidersResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllIdentityProviders(instance.getIdentityProviders());
            return this;
        }

        public final Builder identityProvider(IdentityProvider element) {
            this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
            return this;
        }

        public final Builder identityProvider(IdentityProvider ... elements) {
            for (IdentityProvider element : elements) {
                this.identityProviders.add(Objects.requireNonNull(element, "identityProviders element"));
            }
            return this;
        }

        public final Builder identityProviders(Iterable<? extends IdentityProvider> elements) {
            this.identityProviders.clear();
            return this.addAllIdentityProviders(elements);
        }

        public final Builder addAllIdentityProviders(Iterable<? extends IdentityProvider> elements) {
            for (IdentityProvider identityProvider : elements) {
                this.identityProviders.add(Objects.requireNonNull(identityProvider, "identityProviders element"));
            }
            return this;
        }

        public ListIdentityProvidersResponse build() {
            return new ListIdentityProvidersResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ListIdentityProvidersResponse {
        List<IdentityProvider> identityProviders = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="identityProviders")
        public void setIdentityProviders(List<IdentityProvider> identityProviders) {
            this.identityProviders = identityProviders;
        }

        @Override
        public List<IdentityProvider> getIdentityProviders() {
            throw new UnsupportedOperationException();
        }
    }
}

