/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TlsConfiguration {
    NONE("none"),
    SIMPLE("simple"),
    EXTERNAL("external");

    private final String value;

    private TlsConfiguration(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    static TlsConfiguration from(String s) {
        switch (s.toLowerCase()) {
            case "none": {
                return NONE;
            }
            case "simple": {
                return SIMPLE;
            }
            case "external": {
                return EXTERNAL;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown TLS Configuration type: %s", s));
    }
}

