/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.identityproviders.Type;
import org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest;

public final class UpdateIdentityProviderRequest
extends _UpdateIdentityProviderRequest {
    @Nullable
    private final Boolean active;
    private final String configuration;
    private final String identityProviderId;
    private final String name;
    private final String originKey;
    private final Type type;
    private final Integer version;
    @Nullable
    private final String identityZoneId;

    private UpdateIdentityProviderRequest(Builder builder) {
        this.active = builder.active;
        this.configuration = builder.configuration;
        this.identityProviderId = builder.identityProviderId;
        this.name = builder.name;
        this.originKey = builder.originKey;
        this.type = builder.type;
        this.version = builder.version;
        this.identityZoneId = builder.identityZoneId;
    }

    @Override
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @Override
    public String getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOriginKey() {
        return this.originKey;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateIdentityProviderRequest && this.equalTo((UpdateIdentityProviderRequest)another);
    }

    private boolean equalTo(UpdateIdentityProviderRequest another) {
        return Objects.equals(this.active, another.active) && this.configuration.equals(another.configuration) && this.identityProviderId.equals(another.identityProviderId) && this.name.equals(another.name) && this.originKey.equals(another.originKey) && this.type.equals((Object)another.type) && this.version.equals(another.version) && Objects.equals(this.identityZoneId, another.identityZoneId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.active);
        h = h * 17 + this.configuration.hashCode();
        h = h * 17 + this.identityProviderId.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.originKey.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.version.hashCode();
        h = h * 17 + Objects.hashCode(this.identityZoneId);
        return h;
    }

    public String toString() {
        return "UpdateIdentityProviderRequest{active=" + this.active + ", configuration=" + this.configuration + ", identityProviderId=" + this.identityProviderId + ", name=" + this.name + ", originKey=" + this.originKey + ", type=" + (Object)((Object)this.type) + ", version=" + this.version + ", identityZoneId=" + this.identityZoneId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CONFIGURATION = 1L;
        private static final long INIT_BIT_IDENTITY_PROVIDER_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_ORIGIN_KEY = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private static final long INIT_BIT_VERSION = 32L;
        private long initBits = 63L;
        private Boolean active;
        private String configuration;
        private String identityProviderId;
        private String name;
        private String originKey;
        private Type type;
        private Integer version;
        private String identityZoneId;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateIdentityProviderRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_UpdateIdentityProviderRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            String identityZoneIdValue;
            if (object instanceof IdentityZoned && (identityZoneIdValue = (instance = (IdentityZoned)object).getIdentityZoneId()) != null) {
                this.identityZoneId(identityZoneIdValue);
            }
            if (object instanceof _UpdateIdentityProviderRequest) {
                instance = (_UpdateIdentityProviderRequest)object;
                this.configuration(((_UpdateIdentityProviderRequest)instance).getConfiguration());
                this.originKey(((_UpdateIdentityProviderRequest)instance).getOriginKey());
                this.name(((_UpdateIdentityProviderRequest)instance).getName());
                Boolean activeValue = ((_UpdateIdentityProviderRequest)instance).getActive();
                if (activeValue != null) {
                    this.active(activeValue);
                }
                this.type(((_UpdateIdentityProviderRequest)instance).getType());
                this.version(((_UpdateIdentityProviderRequest)instance).getVersion());
                this.identityProviderId(((_UpdateIdentityProviderRequest)instance).getIdentityProviderId());
            }
        }

        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        public final Builder configuration(String configuration) {
            this.configuration = Objects.requireNonNull(configuration, "configuration");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = Objects.requireNonNull(identityProviderId, "identityProviderId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder originKey(String originKey) {
            this.originKey = Objects.requireNonNull(originKey, "originKey");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder type(Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder version(Integer version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public UpdateIdentityProviderRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateIdentityProviderRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("configuration");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("identityProviderId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("originKey");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build UpdateIdentityProviderRequest, some of required attributes are not set " + attributes;
        }
    }
}

