/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityzones.Links;
import org.cloudfoundry.uaa.identityzones.Prompt;
import org.cloudfoundry.uaa.identityzones.SamlConfiguration;
import org.cloudfoundry.uaa.identityzones.TokenPolicy;
import org.cloudfoundry.uaa.identityzones._IdentityZoneConfiguration;

public final class IdentityZoneConfiguration
extends _IdentityZoneConfiguration {
    @Nullable
    private final Boolean ldapDiscoveryEnabled;
    @Nullable
    private final Links links;
    @Nullable
    private final List<Prompt> prompts;
    @Nullable
    private final SamlConfiguration samlConfiguration;
    @Nullable
    private final TokenPolicy tokenPolicy;

    private IdentityZoneConfiguration(Builder builder) {
        this.ldapDiscoveryEnabled = builder.ldapDiscoveryEnabled;
        this.links = builder.links;
        this.prompts = builder.prompts == null ? null : IdentityZoneConfiguration.createUnmodifiableList(true, builder.prompts);
        this.samlConfiguration = builder.samlConfiguration;
        this.tokenPolicy = builder.tokenPolicy;
    }

    @Override
    @JsonProperty(value="idpDiscoveryEnabled")
    @Nullable
    public Boolean getLdapDiscoveryEnabled() {
        return this.ldapDiscoveryEnabled;
    }

    @Override
    @JsonProperty(value="links")
    @Nullable
    public Links getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="prompts")
    @Nullable
    public List<Prompt> getPrompts() {
        return this.prompts;
    }

    @Override
    @JsonProperty(value="samlConfig")
    @Nullable
    public SamlConfiguration getSamlConfiguration() {
        return this.samlConfiguration;
    }

    @Override
    @JsonProperty(value="tokenPolicy")
    @Nullable
    public TokenPolicy getTokenPolicy() {
        return this.tokenPolicy;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof IdentityZoneConfiguration && this.equalTo((IdentityZoneConfiguration)another);
    }

    private boolean equalTo(IdentityZoneConfiguration another) {
        return Objects.equals(this.ldapDiscoveryEnabled, another.ldapDiscoveryEnabled) && Objects.equals(this.links, another.links) && Objects.equals(this.prompts, another.prompts) && Objects.equals(this.samlConfiguration, another.samlConfiguration) && Objects.equals(this.tokenPolicy, another.tokenPolicy);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.ldapDiscoveryEnabled);
        h = h * 17 + Objects.hashCode(this.links);
        h = h * 17 + Objects.hashCode(this.prompts);
        h = h * 17 + Objects.hashCode(this.samlConfiguration);
        h = h * 17 + Objects.hashCode(this.tokenPolicy);
        return h;
    }

    public String toString() {
        return "IdentityZoneConfiguration{ldapDiscoveryEnabled=" + this.ldapDiscoveryEnabled + ", links=" + this.links + ", prompts=" + this.prompts + ", samlConfiguration=" + this.samlConfiguration + ", tokenPolicy=" + this.tokenPolicy + "}";
    }

    @Deprecated
    @JsonCreator
    static IdentityZoneConfiguration fromJson(Json json) {
        Builder builder = IdentityZoneConfiguration.builder();
        if (json.ldapDiscoveryEnabled != null) {
            builder.ldapDiscoveryEnabled(json.ldapDiscoveryEnabled);
        }
        if (json.links != null) {
            builder.links(json.links);
        }
        if (json.prompts != null) {
            builder.addAllPrompts(json.prompts);
        }
        if (json.samlConfiguration != null) {
            builder.samlConfiguration(json.samlConfiguration);
        }
        if (json.tokenPolicy != null) {
            builder.tokenPolicy(json.tokenPolicy);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Boolean ldapDiscoveryEnabled;
        private Links links;
        private List<Prompt> prompts = null;
        private SamlConfiguration samlConfiguration;
        private TokenPolicy tokenPolicy;

        private Builder() {
        }

        public final Builder from(IdentityZoneConfiguration instance) {
            return this.from((_IdentityZoneConfiguration)instance);
        }

        final Builder from(_IdentityZoneConfiguration instance) {
            TokenPolicy tokenPolicyValue;
            SamlConfiguration samlConfigurationValue;
            List<Prompt> promptsValue;
            Links linksValue;
            Objects.requireNonNull(instance, "instance");
            Boolean ldapDiscoveryEnabledValue = instance.getLdapDiscoveryEnabled();
            if (ldapDiscoveryEnabledValue != null) {
                this.ldapDiscoveryEnabled(ldapDiscoveryEnabledValue);
            }
            if ((linksValue = instance.getLinks()) != null) {
                this.links(linksValue);
            }
            if ((promptsValue = instance.getPrompts()) != null) {
                this.addAllPrompts(promptsValue);
            }
            if ((samlConfigurationValue = instance.getSamlConfiguration()) != null) {
                this.samlConfiguration(samlConfigurationValue);
            }
            if ((tokenPolicyValue = instance.getTokenPolicy()) != null) {
                this.tokenPolicy(tokenPolicyValue);
            }
            return this;
        }

        public final Builder ldapDiscoveryEnabled(@Nullable Boolean ldapDiscoveryEnabled) {
            this.ldapDiscoveryEnabled = ldapDiscoveryEnabled;
            return this;
        }

        public final Builder links(@Nullable Links links) {
            this.links = links;
            return this;
        }

        public final Builder prompt(Prompt element) {
            if (this.prompts == null) {
                this.prompts = new ArrayList<Prompt>();
            }
            this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            return this;
        }

        public final Builder prompt(Prompt ... elements) {
            if (this.prompts == null) {
                this.prompts = new ArrayList<Prompt>();
            }
            for (Prompt element : elements) {
                this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            }
            return this;
        }

        public final Builder prompts(@Nullable Iterable<? extends Prompt> elements) {
            if (elements == null) {
                this.prompts = null;
                return this;
            }
            this.prompts = new ArrayList<Prompt>();
            return this.addAllPrompts(elements);
        }

        public final Builder addAllPrompts(Iterable<? extends Prompt> elements) {
            Objects.requireNonNull(elements, "prompts element");
            if (this.prompts == null) {
                this.prompts = new ArrayList<Prompt>();
            }
            for (Prompt prompt : elements) {
                this.prompts.add(Objects.requireNonNull(prompt, "prompts element"));
            }
            return this;
        }

        public final Builder samlConfiguration(@Nullable SamlConfiguration samlConfiguration) {
            this.samlConfiguration = samlConfiguration;
            return this;
        }

        public final Builder tokenPolicy(@Nullable TokenPolicy tokenPolicy) {
            this.tokenPolicy = tokenPolicy;
            return this;
        }

        public IdentityZoneConfiguration build() {
            return new IdentityZoneConfiguration(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _IdentityZoneConfiguration {
        Boolean ldapDiscoveryEnabled;
        Links links;
        List<Prompt> prompts = null;
        SamlConfiguration samlConfiguration;
        TokenPolicy tokenPolicy;

        Json() {
        }

        @JsonProperty(value="idpDiscoveryEnabled")
        public void setLdapDiscoveryEnabled(@Nullable Boolean ldapDiscoveryEnabled) {
            this.ldapDiscoveryEnabled = ldapDiscoveryEnabled;
        }

        @JsonProperty(value="links")
        public void setLinks(@Nullable Links links) {
            this.links = links;
        }

        @JsonProperty(value="prompts")
        public void setPrompts(@Nullable List<Prompt> prompts) {
            this.prompts = prompts;
        }

        @JsonProperty(value="samlConfig")
        public void setSamlConfiguration(@Nullable SamlConfiguration samlConfiguration) {
            this.samlConfiguration = samlConfiguration;
        }

        @JsonProperty(value="tokenPolicy")
        public void setTokenPolicy(@Nullable TokenPolicy tokenPolicy) {
            this.tokenPolicy = tokenPolicy;
        }

        @Override
        public Boolean getLdapDiscoveryEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Links getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Prompt> getPrompts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SamlConfiguration getSamlConfiguration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TokenPolicy getTokenPolicy() {
            throw new UnsupportedOperationException();
        }
    }
}

