/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityzones._SamlConfiguration;

public final class SamlConfiguration
extends _SamlConfiguration {
    @Nullable
    private final Boolean assertionSigned;
    @Nullable
    private final Integer assertionTimeToLive;
    @Nullable
    private final String certificate;
    @Nullable
    private final String privateKey;
    @Nullable
    private final String privateKeyPassword;
    @Nullable
    private final Boolean requestSigned;
    @Nullable
    private final Boolean wantAssertionSigned;
    @Nullable
    private final Boolean wantPartnerAuthenticationRequestSigned;

    private SamlConfiguration(Builder builder) {
        this.assertionSigned = builder.assertionSigned;
        this.assertionTimeToLive = builder.assertionTimeToLive;
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.privateKeyPassword = builder.privateKeyPassword;
        this.requestSigned = builder.requestSigned;
        this.wantAssertionSigned = builder.wantAssertionSigned;
        this.wantPartnerAuthenticationRequestSigned = builder.wantPartnerAuthenticationRequestSigned;
    }

    @Override
    @JsonProperty(value="assertionSigned")
    @Nullable
    public Boolean getAssertionSigned() {
        return this.assertionSigned;
    }

    @Override
    @JsonProperty(value="assertionTimeToLiveSeconds")
    @Nullable
    public Integer getAssertionTimeToLive() {
        return this.assertionTimeToLive;
    }

    @Override
    @JsonProperty(value="certificate")
    @Nullable
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    @JsonProperty(value="privateKey")
    @Nullable
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    @JsonProperty(value="privateKeyPassword")
    @Nullable
    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    @Override
    @JsonProperty(value="requestSigned")
    @Nullable
    public Boolean getRequestSigned() {
        return this.requestSigned;
    }

    @Override
    @JsonProperty(value="wantAssertionSigned")
    @Nullable
    public Boolean getWantAssertionSigned() {
        return this.wantAssertionSigned;
    }

    @Override
    @JsonProperty(value="wantAuthnRequestSigned")
    @Nullable
    public Boolean getWantPartnerAuthenticationRequestSigned() {
        return this.wantPartnerAuthenticationRequestSigned;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SamlConfiguration && this.equalTo((SamlConfiguration)another);
    }

    private boolean equalTo(SamlConfiguration another) {
        return Objects.equals(this.assertionSigned, another.assertionSigned) && Objects.equals(this.assertionTimeToLive, another.assertionTimeToLive) && Objects.equals(this.certificate, another.certificate) && Objects.equals(this.privateKey, another.privateKey) && Objects.equals(this.privateKeyPassword, another.privateKeyPassword) && Objects.equals(this.requestSigned, another.requestSigned) && Objects.equals(this.wantAssertionSigned, another.wantAssertionSigned) && Objects.equals(this.wantPartnerAuthenticationRequestSigned, another.wantPartnerAuthenticationRequestSigned);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.assertionSigned);
        h = h * 17 + Objects.hashCode(this.assertionTimeToLive);
        h = h * 17 + Objects.hashCode(this.certificate);
        h = h * 17 + Objects.hashCode(this.privateKey);
        h = h * 17 + Objects.hashCode(this.privateKeyPassword);
        h = h * 17 + Objects.hashCode(this.requestSigned);
        h = h * 17 + Objects.hashCode(this.wantAssertionSigned);
        h = h * 17 + Objects.hashCode(this.wantPartnerAuthenticationRequestSigned);
        return h;
    }

    public String toString() {
        return "SamlConfiguration{assertionSigned=" + this.assertionSigned + ", assertionTimeToLive=" + this.assertionTimeToLive + ", certificate=" + this.certificate + ", privateKey=" + this.privateKey + ", privateKeyPassword=" + this.privateKeyPassword + ", requestSigned=" + this.requestSigned + ", wantAssertionSigned=" + this.wantAssertionSigned + ", wantPartnerAuthenticationRequestSigned=" + this.wantPartnerAuthenticationRequestSigned + "}";
    }

    @Deprecated
    @JsonCreator
    static SamlConfiguration fromJson(Json json) {
        Builder builder = SamlConfiguration.builder();
        if (json.assertionSigned != null) {
            builder.assertionSigned(json.assertionSigned);
        }
        if (json.assertionTimeToLive != null) {
            builder.assertionTimeToLive(json.assertionTimeToLive);
        }
        if (json.certificate != null) {
            builder.certificate(json.certificate);
        }
        if (json.privateKey != null) {
            builder.privateKey(json.privateKey);
        }
        if (json.privateKeyPassword != null) {
            builder.privateKeyPassword(json.privateKeyPassword);
        }
        if (json.requestSigned != null) {
            builder.requestSigned(json.requestSigned);
        }
        if (json.wantAssertionSigned != null) {
            builder.wantAssertionSigned(json.wantAssertionSigned);
        }
        if (json.wantPartnerAuthenticationRequestSigned != null) {
            builder.wantPartnerAuthenticationRequestSigned(json.wantPartnerAuthenticationRequestSigned);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean assertionSigned;
        private Integer assertionTimeToLive;
        private String certificate;
        private String privateKey;
        private String privateKeyPassword;
        private Boolean requestSigned;
        private Boolean wantAssertionSigned;
        private Boolean wantPartnerAuthenticationRequestSigned;

        private Builder() {
        }

        public final Builder from(SamlConfiguration instance) {
            return this.from((_SamlConfiguration)instance);
        }

        final Builder from(_SamlConfiguration instance) {
            Boolean wantPartnerAuthenticationRequestSignedValue;
            Boolean wantAssertionSignedValue;
            Boolean requestSignedValue;
            String privateKeyPasswordValue;
            String privateKeyValue;
            String certificateValue;
            Integer assertionTimeToLiveValue;
            Objects.requireNonNull(instance, "instance");
            Boolean assertionSignedValue = instance.getAssertionSigned();
            if (assertionSignedValue != null) {
                this.assertionSigned(assertionSignedValue);
            }
            if ((assertionTimeToLiveValue = instance.getAssertionTimeToLive()) != null) {
                this.assertionTimeToLive(assertionTimeToLiveValue);
            }
            if ((certificateValue = instance.getCertificate()) != null) {
                this.certificate(certificateValue);
            }
            if ((privateKeyValue = instance.getPrivateKey()) != null) {
                this.privateKey(privateKeyValue);
            }
            if ((privateKeyPasswordValue = instance.getPrivateKeyPassword()) != null) {
                this.privateKeyPassword(privateKeyPasswordValue);
            }
            if ((requestSignedValue = instance.getRequestSigned()) != null) {
                this.requestSigned(requestSignedValue);
            }
            if ((wantAssertionSignedValue = instance.getWantAssertionSigned()) != null) {
                this.wantAssertionSigned(wantAssertionSignedValue);
            }
            if ((wantPartnerAuthenticationRequestSignedValue = instance.getWantPartnerAuthenticationRequestSigned()) != null) {
                this.wantPartnerAuthenticationRequestSigned(wantPartnerAuthenticationRequestSignedValue);
            }
            return this;
        }

        public final Builder assertionSigned(@Nullable Boolean assertionSigned) {
            this.assertionSigned = assertionSigned;
            return this;
        }

        public final Builder assertionTimeToLive(@Nullable Integer assertionTimeToLive) {
            this.assertionTimeToLive = assertionTimeToLive;
            return this;
        }

        public final Builder certificate(@Nullable String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final Builder privateKey(@Nullable String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final Builder privateKeyPassword(@Nullable String privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
            return this;
        }

        public final Builder requestSigned(@Nullable Boolean requestSigned) {
            this.requestSigned = requestSigned;
            return this;
        }

        public final Builder wantAssertionSigned(@Nullable Boolean wantAssertionSigned) {
            this.wantAssertionSigned = wantAssertionSigned;
            return this;
        }

        public final Builder wantPartnerAuthenticationRequestSigned(@Nullable Boolean wantPartnerAuthenticationRequestSigned) {
            this.wantPartnerAuthenticationRequestSigned = wantPartnerAuthenticationRequestSigned;
            return this;
        }

        public SamlConfiguration build() {
            return new SamlConfiguration(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _SamlConfiguration {
        Boolean assertionSigned;
        Integer assertionTimeToLive;
        String certificate;
        String privateKey;
        String privateKeyPassword;
        Boolean requestSigned;
        Boolean wantAssertionSigned;
        Boolean wantPartnerAuthenticationRequestSigned;

        Json() {
        }

        @JsonProperty(value="assertionSigned")
        public void setAssertionSigned(@Nullable Boolean assertionSigned) {
            this.assertionSigned = assertionSigned;
        }

        @JsonProperty(value="assertionTimeToLiveSeconds")
        public void setAssertionTimeToLive(@Nullable Integer assertionTimeToLive) {
            this.assertionTimeToLive = assertionTimeToLive;
        }

        @JsonProperty(value="certificate")
        public void setCertificate(@Nullable String certificate) {
            this.certificate = certificate;
        }

        @JsonProperty(value="privateKey")
        public void setPrivateKey(@Nullable String privateKey) {
            this.privateKey = privateKey;
        }

        @JsonProperty(value="privateKeyPassword")
        public void setPrivateKeyPassword(@Nullable String privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
        }

        @JsonProperty(value="requestSigned")
        public void setRequestSigned(@Nullable Boolean requestSigned) {
            this.requestSigned = requestSigned;
        }

        @JsonProperty(value="wantAssertionSigned")
        public void setWantAssertionSigned(@Nullable Boolean wantAssertionSigned) {
            this.wantAssertionSigned = wantAssertionSigned;
        }

        @JsonProperty(value="wantAuthnRequestSigned")
        public void setWantPartnerAuthenticationRequestSigned(@Nullable Boolean wantPartnerAuthenticationRequestSigned) {
            this.wantPartnerAuthenticationRequestSigned = wantPartnerAuthenticationRequestSigned;
        }

        @Override
        public Boolean getAssertionSigned() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getAssertionTimeToLive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCertificate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrivateKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrivateKeyPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getRequestSigned() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getWantAssertionSigned() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getWantPartnerAuthenticationRequestSigned() {
            throw new UnsupportedOperationException();
        }
    }
}

