/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.users.ApprovalStatus;
import org.cloudfoundry.uaa.users._Approval;

public final class Approval
extends _Approval {
    private final String clientId;
    private final String expiresAt;
    private final String lastUpdatedAt;
    private final String scope;
    private final ApprovalStatus status;
    private final String userId;

    private Approval(Builder builder) {
        this.clientId = builder.clientId;
        this.expiresAt = builder.expiresAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.scope = builder.scope;
        this.status = builder.status;
        this.userId = builder.userId;
    }

    @Override
    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="expiresAt")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    @JsonProperty(value="lastUpdatedAt")
    public String getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    @Override
    @JsonProperty(value="scope")
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="status")
    public ApprovalStatus getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Approval && this.equalTo((Approval)another);
    }

    private boolean equalTo(Approval another) {
        return this.clientId.equals(another.clientId) && this.expiresAt.equals(another.expiresAt) && this.lastUpdatedAt.equals(another.lastUpdatedAt) && this.scope.equals(another.scope) && this.status.equals((Object)another.status) && this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.clientId.hashCode();
        h = h * 17 + this.expiresAt.hashCode();
        h = h * 17 + this.lastUpdatedAt.hashCode();
        h = h * 17 + this.scope.hashCode();
        h = h * 17 + this.status.hashCode();
        h = h * 17 + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "Approval{clientId=" + this.clientId + ", expiresAt=" + this.expiresAt + ", lastUpdatedAt=" + this.lastUpdatedAt + ", scope=" + this.scope + ", status=" + (Object)((Object)this.status) + ", userId=" + this.userId + "}";
    }

    @Deprecated
    @JsonCreator
    static Approval fromJson(Json json) {
        Builder builder = Approval.builder();
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.expiresAt != null) {
            builder.expiresAt(json.expiresAt);
        }
        if (json.lastUpdatedAt != null) {
            builder.lastUpdatedAt(json.lastUpdatedAt);
        }
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_EXPIRES_AT = 2L;
        private static final long INIT_BIT_LAST_UPDATED_AT = 4L;
        private static final long INIT_BIT_SCOPE = 8L;
        private static final long INIT_BIT_STATUS = 16L;
        private static final long INIT_BIT_USER_ID = 32L;
        private long initBits = 63L;
        private String clientId;
        private String expiresAt;
        private String lastUpdatedAt;
        private String scope;
        private ApprovalStatus status;
        private String userId;

        private Builder() {
        }

        public final Builder from(Approval instance) {
            return this.from((_Approval)instance);
        }

        final Builder from(_Approval instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.getClientId());
            this.expiresAt(instance.getExpiresAt());
            this.lastUpdatedAt(instance.getLastUpdatedAt());
            this.scope(instance.getScope());
            this.status(instance.getStatus());
            this.userId(instance.getUserId());
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder expiresAt(String expiresAt) {
            this.expiresAt = Objects.requireNonNull(expiresAt, "expiresAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lastUpdatedAt(String lastUpdatedAt) {
            this.lastUpdatedAt = Objects.requireNonNull(lastUpdatedAt, "lastUpdatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder scope(String scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder status(ApprovalStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder userId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public Approval build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Approval(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expiresAt");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastUpdatedAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build Approval, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Approval {
        String clientId;
        String expiresAt;
        String lastUpdatedAt;
        String scope;
        ApprovalStatus status;
        String userId;

        Json() {
        }

        @JsonProperty(value="clientId")
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="expiresAt")
        public void setExpiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
        }

        @JsonProperty(value="lastUpdatedAt")
        public void setLastUpdatedAt(String lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @JsonProperty(value="scope")
        public void setScope(String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="status")
        public void setStatus(ApprovalStatus status) {
            this.status = status;
        }

        @JsonProperty(value="userId")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExpiresAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLastUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ApprovalStatus getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }
    }
}

