/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.Versioned;
import org.cloudfoundry.uaa.users._DeleteUserRequest;

public final class DeleteUserRequest
extends _DeleteUserRequest {
    private final String userId;
    @Nullable
    private final String version;

    private DeleteUserRequest(Builder builder) {
        this.userId = builder.userId;
        this.version = builder.version;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteUserRequest && this.equalTo((DeleteUserRequest)another);
    }

    private boolean equalTo(DeleteUserRequest another) {
        return this.userId.equals(another.userId) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return "DeleteUserRequest{userId=" + this.userId + ", version=" + this.version + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private long initBits = 1L;
        private String userId;
        private String version;

        private Builder() {
        }

        public final Builder from(DeleteUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_DeleteUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Versioned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String versionValue;
            Versioned instance;
            if (object instanceof _DeleteUserRequest) {
                instance = (_DeleteUserRequest)object;
                this.userId(((_DeleteUserRequest)instance).getUserId());
            }
            if (object instanceof Versioned && (versionValue = (instance = (Versioned)object).getVersion()) != null) {
                this.version(versionValue);
            }
        }

        public final Builder userId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public DeleteUserRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteUserRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build DeleteUserRequest, some of required attributes are not set " + attributes;
        }
    }
}

